/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.layout.flow;

import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.policy.layout.flow.AbstractFlowLayoutEditPolicy;
import org.eclipse.wb.core.model.IObjectInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IPasteComponentProcessor;

public abstract class ObjectFlowLayoutEditPolicy<C>
extends AbstractFlowLayoutEditPolicy {
    private final ObjectInfo m_host;

    public ObjectFlowLayoutEditPolicy(IObjectInfo host) {
        this(host.getUnderlyingModel());
    }

    public ObjectFlowLayoutEditPolicy(ObjectInfo host) {
        this.m_host = host;
    }

    @Override
    protected Command getCreateCommand(final Object newObject, final Object referenceObject) {
        return new EditCommand(this.m_host){

            @Override
            protected void executeEdit() throws Exception {
                ObjectFlowLayoutEditPolicy.this.command_CREATE(ObjectFlowLayoutEditPolicy.this.getObjectModel(newObject), ObjectFlowLayoutEditPolicy.this.getReferenceObjectModel(referenceObject));
            }
        };
    }

    @Override
    protected Command getPasteCommand(PasteRequest request, Object referenceObject) {
        final C referenceModel = this.getReferenceObjectModel(referenceObject);
        return GlobalState.getPasteRequestProcessor().getPasteCommand(request, new IPasteComponentProcessor(){

            @Override
            public void process(Object component) throws Exception {
                ObjectFlowLayoutEditPolicy.this.command_CREATE(ObjectFlowLayoutEditPolicy.this.getObjectModel(component), referenceModel);
            }
        });
    }

    @Override
    protected Command getMoveCommand(final Object moveObject, final Object referenceObject) {
        return new EditCommand(this.m_host){

            @Override
            protected void executeEdit() throws Exception {
                ObjectFlowLayoutEditPolicy.this.command_MOVE(ObjectFlowLayoutEditPolicy.this.getObjectModel(moveObject), ObjectFlowLayoutEditPolicy.this.getReferenceObjectModel(referenceObject));
            }
        };
    }

    @Override
    protected Command getAddCommand(final Object addObject, final Object referenceObject) {
        return new EditCommand(this.m_host){

            @Override
            protected void executeEdit() throws Exception {
                ObjectFlowLayoutEditPolicy.this.command_ADD(ObjectFlowLayoutEditPolicy.this.getObjectModel(addObject), ObjectFlowLayoutEditPolicy.this.getReferenceObjectModel(referenceObject));
            }
        };
    }

    protected C getObjectModel(Object object) {
        return (C)object;
    }

    protected C getReferenceObjectModel(Object referenceObject) {
        return (C)referenceObject;
    }

    protected abstract void command_CREATE(C var1, C var2) throws Exception;

    protected abstract void command_MOVE(C var1, C var2) throws Exception;

    protected void command_ADD(C component, C referenceComponent) throws Exception {
        this.command_MOVE(component, referenceComponent);
    }
}

