/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;

public class ContentTypeSpecs {
    String[] fFilenames = new String[0];
    String[] fExtensions = new String[0];

    public static ContentTypeSpecs createFor(String contentTypeId) {
        IContentType baseContentType = Platform.getContentTypeManager().getContentType(contentTypeId);
        Object[] baseExtensions = baseContentType.getFileSpecs(8);
        Arrays.sort(baseExtensions);
        HashSet<String> filenameExtensions = new HashSet<String>();
        HashSet<String> filenames = new HashSet<String>();
        IContentType[] contentTypes = Platform.getContentTypeManager().getAllContentTypes();
        int i = 0;
        int length = contentTypes.length;
        while (i < length) {
            if (contentTypes[i].isKindOf(baseContentType)) {
                String[] fileExtension = contentTypes[i].getFileSpecs(8);
                int j = 0;
                while (j < fileExtension.length) {
                    filenameExtensions.add(fileExtension[j]);
                    ++j;
                }
                String[] names = contentTypes[i].getFileSpecs(4);
                int j2 = 0;
                while (j2 < names.length) {
                    filenames.add(names[j2]);
                    ++j2;
                }
            }
            ++i;
        }
        String[] stringExtensions = filenameExtensions.toArray(new String[filenameExtensions.size()]);
        int i2 = stringExtensions.length - 1;
        while (i2 > 0) {
            if (Arrays.binarySearch(baseExtensions, stringExtensions[i2]) >= 0) {
                stringExtensions[i2] = stringExtensions[i2 - 1];
            }
            --i2;
        }
        return new ContentTypeSpecs(filenames.toArray(new String[filenames.size()]), stringExtensions);
    }

    private ContentTypeSpecs(String[] fileNames, String[] extensions) {
        this.fFilenames = fileNames;
        this.fExtensions = extensions;
        Arrays.sort(fileNames);
    }

    public boolean matches(String filename) {
        if (Arrays.binarySearch(this.fFilenames, filename) >= 0) {
            return true;
        }
        int i = 0;
        while (i < this.fExtensions.length) {
            if (filename.length() > this.fExtensions[i].length() + 1 && filename.charAt(filename.length() - this.fExtensions[i].length() - 1) == '.' && filename.endsWith(this.fExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addFilename(String filename) {
        ArrayList<String> combinedList = new ArrayList<String>(this.fFilenames.length + 1);
        int i = 0;
        while (i < this.fFilenames.length) {
            combinedList.add(this.fFilenames[i]);
            ++i;
        }
        combinedList.add(filename);
        Object[] combinedArray = combinedList.toArray(new String[combinedList.size()]);
        Arrays.sort(combinedArray);
        this.fFilenames = combinedArray;
    }

    public void addFilenameExtension(String extension) {
        ArrayList<String> combinedList = new ArrayList<String>(this.fExtensions.length + 1);
        int i = 0;
        while (i < this.fExtensions.length) {
            combinedList.add(this.fExtensions[i]);
            ++i;
        }
        combinedList.add(extension);
        String[] combinedArray = combinedList.toArray(new String[combinedList.size()]);
        this.fExtensions = combinedArray;
    }
}

