/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.transport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.JSON;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;

public abstract class CFPacket
implements Packet {
    public static boolean TRACE = false;
    private final String type;
    private final String context_id;

    protected CFPacket(String type, String context_id) {
        if (type == null) {
            throw new IllegalArgumentException("The type for a packet cannot be null");
        }
        this.type = type.intern();
        this.context_id = context_id;
    }

    protected CFPacket(Map json) {
        if (json == null) {
            throw new IllegalArgumentException("The JSON map for a packet cannot be null");
        }
        String packetType = (String)json.get("type");
        this.type = packetType.intern();
        this.context_id = (String)json.get("contextId");
    }

    public String getContextId() {
        return this.context_id;
    }

    public String getType() {
        return this.type;
    }

    public Map toJSON() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("type", this.type);
        if (this.context_id != null) {
            json.put("contextId", this.context_id);
        }
        return json;
    }

    public static String getType(Map json) {
        if (json == null) {
            throw new IllegalArgumentException("A null JSON map is not allowed when trying to get the packet type");
        }
        return (String)json.get("type");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Map json = this.toJSON();
        buffer.append("CFPacket: ");
        JSON.writeValue(json, buffer);
        return buffer.toString();
    }

    public static void setTracing(boolean tracing) {
        TRACE = tracing;
    }
}

