/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.wsfinder;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.ws.internal.converter.IIFile2UriConverter;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.wsfinder.AbstractWebServiceLocator;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;

public class WorkspaceWSDLLocator
extends AbstractWebServiceLocator {
    protected List wsdlServices = null;
    private static final String PLATFORM_RES = "platform:/resource";
    private static final String WSDL_EXT = "wsdl";

    public List getWebServices(IProgressMonitor monitor) {
        if (this.wsdlServices == null) {
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                WSDLVisitor visitor = new WSDLVisitor();
                root.accept((IResourceVisitor)visitor);
                this.wsdlServices = visitor.getWSDL();
            }
            catch (Exception exception) {}
        }
        return this.wsdlServices;
    }

    public List getWebServices(IProject[] projects, IProgressMonitor monitor) {
        WSDLVisitor visitor = new WSDLVisitor();
        if (projects != null) {
            int p = 0;
            while (p < projects.length) {
                try {
                    projects[p].accept((IResourceVisitor)visitor);
                }
                catch (CoreException coreException) {}
                ++p;
            }
        }
        return visitor.getWSDL();
    }

    private class WSDLVisitor
    implements IResourceVisitor {
        private Vector wsdl = new Vector();

        private WSDLVisitor() {
        }

        public boolean visit(IResource resource) {
            if (resource.getType() == 1) {
                String ext;
                String wsdlURL = null;
                IIFile2UriConverter converter = WSPlugin.getInstance().getIFile2UriConverter();
                boolean allowBaseConversionOnFailure = true;
                if (converter != null && (wsdlURL = converter.convert((IFile)resource)) == null) {
                    allowBaseConversionOnFailure = converter.allowBaseConversionOnFailure();
                }
                if (wsdlURL == null && allowBaseConversionOnFailure && (ext = resource.getFileExtension()) != null && ext.equalsIgnoreCase(WorkspaceWSDLLocator.WSDL_EXT)) {
                    wsdlURL = WorkspaceWSDLLocator.PLATFORM_RES + resource.getFullPath().toString();
                }
                if (wsdlURL != null) {
                    WebServiceInfo wsInfo = new WebServiceInfo();
                    wsInfo.setWsdlURL(wsdlURL);
                    this.wsdl.add(wsInfo);
                }
            }
            return true;
        }

        public Vector getWSDL() {
            return this.wsdl;
        }
    }
}

