/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.model.CallTemplate;
import org.eclipse.wst.xsl.core.model.Function;
import org.eclipse.wst.xsl.core.model.Import;
import org.eclipse.wst.xsl.core.model.Include;
import org.eclipse.wst.xsl.core.model.Stylesheet;
import org.eclipse.wst.xsl.core.model.Template;
import org.eclipse.wst.xsl.core.model.Variable;
import org.eclipse.wst.xsl.core.model.XSLModelObject;

public class StylesheetModel
extends XSLModelObject {
    private final Stylesheet stylesheet;
    boolean circularReference;
    final Set<IFile> files = new HashSet<IFile>();
    final Set<Stylesheet> stylesheets = new HashSet<Stylesheet>();
    final List<Include> includeModel = new ArrayList<Include>();
    final List<Import> importModel = new ArrayList<Import>();
    final Set<Template> templateSet = new HashSet<Template>();
    final List<Template> templates = new ArrayList<Template>();
    final List<Variable> globalVariables = new ArrayList<Variable>();
    final List<CallTemplate> callTemplates = new ArrayList<CallTemplate>();
    final List<Function> functions = new ArrayList<Function>();

    public StylesheetModel(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public List<Include> getIncludes() {
        return this.includeModel;
    }

    public Set<IFile> getFileDependencies() {
        return this.files;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public List<Variable> getGlobalVariables() {
        return this.globalVariables;
    }

    public List<Template> getTemplates() {
        return this.templates;
    }

    public List<Template> findAllNestedTemplates() {
        ArrayList<Template> allTemplates = new ArrayList<Template>();
        for (Stylesheet stylesheet : this.stylesheets) {
            allTemplates.addAll(stylesheet.getTemplates());
        }
        return allTemplates;
    }

    public List<Template> getTemplatesByName(String name) {
        ArrayList<Template> matching = new ArrayList<Template>(this.templates.size());
        for (Template template : this.templates) {
            if (!name.equals(template.getName())) continue;
            matching.add(template);
        }
        return matching;
    }

    public List<Template> findMatching(Template toMatch) {
        ArrayList<Template> matching = new ArrayList<Template>(this.templates.size());
        for (Template template : this.templates) {
            if (!template.equals((Object)toMatch)) continue;
            matching.add(template);
        }
        return matching;
    }

    public boolean hasCircularReference() {
        return this.circularReference;
    }

    public void fix() {
        long start = System.currentTimeMillis();
        this.templates.addAll(this.stylesheet.getTemplates());
        this.templateSet.addAll(this.stylesheet.getTemplates());
        this.globalVariables.addAll(this.stylesheet.globalVariables);
        this.callTemplates.addAll(this.stylesheet.getCalledTemplates());
        this.functions.addAll(this.stylesheet.getFunctions());
        for (Include include : this.stylesheet.getIncludes()) {
            this.handleInclude(include);
        }
        for (Import import_ : this.stylesheet.getImports()) {
            this.handleInclude(import_);
        }
        this.circularReference = this.checkCycles();
    }

    private boolean checkCycles() {
        HashSet<IFile> seen = new HashSet<IFile>();
        IFile mainFile = this.getStylesheet().getFile();
        if (StylesheetModel.checkCycles(mainFile, seen)) {
            return true;
        }
        seen.add(mainFile);
        for (IFile file : this.files) {
            if (file.equals((Object)mainFile) || !StylesheetModel.checkCycles(file, seen)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkCycles(IFile included, Set<IFile> seen) {
        if (seen.contains(included)) {
            return true;
        }
        seen.add(included);
        StylesheetModel includedModel = XSLCore.getInstance().getStylesheet(included);
        for (Include inc : includedModel.getIncludes()) {
            IFile includedFile = inc.getHrefAsFile();
            if (!StylesheetModel.checkCycles(includedFile, seen)) continue;
            return true;
        }
        seen.remove(included);
        return false;
    }

    private void handleInclude(Include include) {
        IFile file = include.getHrefAsFile();
        if (file == null || !file.exists()) {
            return;
        }
        this.files.add(file);
        StylesheetModel includedModel = XSLCore.getInstance().getStylesheet(file);
        if (includedModel == null) {
            return;
        }
        this.stylesheets.add(includedModel.getStylesheet());
        this.globalVariables.addAll(includedModel.globalVariables);
        this.callTemplates.addAll(includedModel.getCallTemplates());
        if (include.getIncludeType() == 1) {
            this.includeModel.add(include);
            this.templates.addAll(includedModel.getTemplates());
            this.templateSet.addAll(includedModel.getTemplates());
        } else {
            this.importModel.add((Import)include);
            for (Template includedTemplate : includedModel.getTemplates()) {
                if (this.templateSet.contains((Object)includedTemplate)) continue;
                this.templates.add(includedTemplate);
                this.templateSet.add(includedTemplate);
            }
        }
    }

    @Override
    public XSLModelObject.Type getModelType() {
        return XSLModelObject.Type.STYLESHEET_MODEL;
    }

    public List<CallTemplate> getCallTemplates() {
        return this.callTemplates;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    public List<Function> getFunctionByName(String name) {
        ArrayList<Function> matching = new ArrayList<Function>(this.functions.size());
        for (Function function : this.functions) {
            if (!name.equals(function.getName())) continue;
            matching.add(function);
        }
        return matching;
    }
}

