/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class SerializationExtensions {
    public static <T extends ENamedElement> T readEcoreElement(ObjectInput in) throws IOException {
        URI uri = SerializationExtensions.readURI(in);
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri.trimFragment().toString());
        Resource _eResource = null;
        if (ePackage != null) {
            _eResource = ePackage.eResource();
        }
        EObject _eObject = null;
        if (_eResource != null) {
            _eObject = _eResource.getEObject(uri.fragment());
        }
        return (T)((ENamedElement)_eObject);
    }

    public static void writeEcoreElement(ObjectOutput out, ENamedElement namedElement) throws IOException {
        URI uri = EcoreUtil.getURI((EObject)namedElement);
        SerializationExtensions.writeURI(out, uri);
    }

    public static <T> T readCastedObject(ObjectInput in) throws IOException {
        try {
            Object _readObject = in.readObject();
            return (T)_readObject;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static URI readURI(ObjectInput in) throws IOException {
        String stringRep = in.readUTF();
        boolean _equals = Objects.equal((Object)stringRep, (Object)"NULL");
        if (_equals) {
            return null;
        }
        return URI.createURI((String)stringRep);
    }

    public static void writeURI(ObjectOutput out, URI uri) throws IOException {
        if (uri == null) {
            out.writeUTF("NULL");
        } else {
            out.writeUTF(uri.toString());
        }
    }

    public static QualifiedName readQualifiedName(ObjectInput in) throws IOException {
        try {
            Object _readObject = in.readObject();
            return QualifiedName.create((ArrayList)_readObject);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void writeQualifiedName(ObjectOutput out, QualifiedName name) throws IOException {
        List<String> _segments = name.getSegments();
        ArrayList<String> _arrayList = new ArrayList<String>(_segments);
        out.writeObject(_arrayList);
    }
}

