/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security;

import java.util.Iterator;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.Permission;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityItem;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.net4j.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RealmUtil {
    private RealmUtil() {
    }

    public static User findUser(EList<SecurityItem> items, String userID) {
        for (SecurityItem item : items) {
            Directory directory;
            User user;
            if (item instanceof User) {
                User user2 = (User)item;
                if (!ObjectUtil.equals((Object)user2.getId(), (Object)userID)) continue;
                return user2;
            }
            if (!(item instanceof Directory) || (user = RealmUtil.findUser((directory = (Directory)item).getItems(), userID)) == null) continue;
            return user;
        }
        return null;
    }

    public static Group findGroup(EList<SecurityItem> items, String groupID) {
        for (SecurityItem item : items) {
            Directory directory;
            Group group;
            if (item instanceof Group) {
                Group group2 = (Group)item;
                if (!ObjectUtil.equals((Object)group2.getId(), (Object)groupID)) continue;
                return group2;
            }
            if (!(item instanceof Directory) || (group = RealmUtil.findGroup((directory = (Directory)item).getItems(), groupID)) == null) continue;
            return group;
        }
        return null;
    }

    public static Role findRole(EList<SecurityItem> items, String roleID) {
        for (SecurityItem item : items) {
            Directory directory;
            Role role;
            if (item instanceof Role) {
                Role role2 = (Role)item;
                if (!ObjectUtil.equals((Object)role2.getId(), (Object)roleID)) continue;
                return role2;
            }
            if (!(item instanceof Directory) || (role = RealmUtil.findRole((directory = (Directory)item).getItems(), roleID)) == null) continue;
            return role;
        }
        return null;
    }

    public static User removeUser(EList<SecurityItem> items, String userID) {
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Directory directory;
            User user;
            SecurityItem item = (SecurityItem)it.next();
            if (item instanceof User) {
                User user2 = (User)item;
                if (!ObjectUtil.equals((Object)user2.getId(), (Object)userID)) continue;
                it.remove();
                return user2;
            }
            if (!(item instanceof Directory) || (user = RealmUtil.removeUser((directory = (Directory)item).getItems(), userID)) == null) continue;
            return user;
        }
        return null;
    }

    public static Group removeGroup(EList<SecurityItem> items, String groupID) {
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Directory directory;
            Group group;
            SecurityItem item = (SecurityItem)it.next();
            if (item instanceof Group) {
                Group group2 = (Group)item;
                if (!ObjectUtil.equals((Object)group2.getId(), (Object)groupID)) continue;
                it.remove();
                return group2;
            }
            if (!(item instanceof Directory) || (group = RealmUtil.removeGroup((directory = (Directory)item).getItems(), groupID)) == null) continue;
            return group;
        }
        return null;
    }

    public static Role removeRole(EList<SecurityItem> items, String roleID) {
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Directory directory;
            Role role;
            SecurityItem item = (SecurityItem)it.next();
            if (item instanceof Role) {
                Role role2 = (Role)item;
                if (!ObjectUtil.equals((Object)role2.getId(), (Object)roleID)) continue;
                it.remove();
                return role2;
            }
            if (!(item instanceof Directory) || (role = RealmUtil.removeRole((directory = (Directory)item).getItems(), roleID)) == null) continue;
            return role;
        }
        return null;
    }

    public static BasicEList<User> allUsers(EList<SecurityItem> items) {
        BasicEList result = new BasicEList();
        RealmUtil.allUsers(items, (EList<User>)result);
        return result;
    }

    public static BasicEList<Group> allGroups(EList<SecurityItem> items) {
        BasicEList result = new BasicEList();
        RealmUtil.allGroups(items, (EList<Group>)result);
        return result;
    }

    public static BasicEList<Role> allRoles(EList<SecurityItem> items) {
        BasicEList result = new BasicEList();
        RealmUtil.allRoles(items, (EList<Role>)result);
        return result;
    }

    public static BasicEList<Permission> allPermissions(EList<SecurityItem> items) {
        BasicEList result = new BasicEList();
        RealmUtil.allPermissions(items, (EList<Permission>)result);
        return result;
    }

    private static void allUsers(EList<SecurityItem> items, EList<User> result) {
        for (SecurityItem item : items) {
            if (item instanceof User) {
                User user = (User)item;
                result.add((Object)user);
                continue;
            }
            if (!(item instanceof Directory)) continue;
            Directory directory = (Directory)item;
            RealmUtil.allUsers(directory.getItems(), result);
        }
    }

    private static void allGroups(EList<SecurityItem> items, EList<Group> result) {
        for (SecurityItem item : items) {
            if (item instanceof Group) {
                Group group = (Group)item;
                result.add((Object)group);
                continue;
            }
            if (!(item instanceof Directory)) continue;
            Directory directory = (Directory)item;
            RealmUtil.allGroups(directory.getItems(), result);
        }
    }

    private static void allRoles(EList<SecurityItem> items, EList<Role> result) {
        for (SecurityItem item : items) {
            if (item instanceof Role) {
                Role role = (Role)item;
                result.add((Object)role);
                continue;
            }
            if (!(item instanceof Directory)) continue;
            Directory directory = (Directory)item;
            RealmUtil.allRoles(directory.getItems(), result);
        }
    }

    private static void allPermissions(EList<SecurityItem> items, EList<Permission> result) {
        for (SecurityItem item : items) {
            if (item instanceof Role) {
                Role role = (Role)item;
                result.addAll(role.getPermissions());
                continue;
            }
            if (!(item instanceof Directory)) continue;
            Directory directory = (Directory)item;
            RealmUtil.allPermissions(directory.getItems(), result);
        }
    }
}

