/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.security.ClassFilter;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.impl.PermissionFilterImpl;
import org.eclipse.emf.cdo.security.impl.PermissionImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ClassFilterImpl
extends PermissionFilterImpl
implements ClassFilter {
    protected ClassFilterImpl() {
    }

    protected EClass eStaticClass() {
        return SecurityPackage.Literals.CLASS_FILTER;
    }

    public EClass getApplicableClass() {
        return (EClass)this.eGet((EStructuralFeature)SecurityPackage.Literals.CLASS_FILTER__APPLICABLE_CLASS, true);
    }

    public void setApplicableClass(EClass newApplicableClass) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.CLASS_FILTER__APPLICABLE_CLASS, newApplicableClass);
    }

    public boolean isSubTypes() {
        return (Boolean)this.eGet((EStructuralFeature)SecurityPackage.Literals.CLASS_FILTER__SUB_TYPES, true);
    }

    public void setSubTypes(boolean newSubTypes) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.CLASS_FILTER__SUB_TYPES, newSubTypes);
    }

    protected boolean filter(CDORevision revision, CDORevisionProvider revisionProvider, CDOBranchPoint securityContext, int level) throws Exception {
        EClass actualClass = revision.getEClass();
        EClass applicableClass = this.getApplicableClass();
        if (this.isSubTypes()) {
            return applicableClass.isSuperTypeOf(actualClass);
        }
        return applicableClass == actualClass;
    }

    public boolean isImpacted(PermissionImpl.CommitImpactContext context) {
        return false;
    }

    public String format() {
        String label = "?";
        EClass applicableClass = this.getApplicableClass();
        if (applicableClass != null) {
            label = String.valueOf(applicableClass.getEPackage().getName()) + "." + applicableClass.getName();
        }
        String operator = this.formatOperator();
        return "class" + operator + label;
    }

    private String formatOperator() {
        return this.isSubTypes() ? " >= " : " == ";
    }
}

