/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.CalcTypes;
import org.eclipse.jubula.client.core.businessprocess.CompNameResult;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;

public class CompNamesBP {
    private void addPropagatedPairs(Map<String, ICompNamesPairPO> pairs, IExecTestCasePO execNode) {
        for (ICompNamesPairPO pair : execNode.getCompNamesPairs()) {
            String name;
            if (!pair.isPropagated() || pairs.containsKey(name = pair.getSecondName())) continue;
            pairs.put(name, PoMaker.createCompNamesPairPO(name, ""));
        }
    }

    private void addCapComponentName(Map<String, ICompNamesPairPO> pairs, ICapPO capNode) {
        Component component = capNode.getMetaComponentType();
        if (component instanceof ConcreteComponent && ((ConcreteComponent)component).hasDefaultMapping()) {
            return;
        }
        String name = capNode.getComponentName();
        String type = capNode.getComponentType();
        if (!pairs.containsKey(name)) {
            ICompNamesPairPO pair = PoMaker.createCompNamesPairPO(name, type);
            pairs.put(name, pair);
        }
    }

    public List<ICompNamesPairPO> getAllCompNamesPairs(IExecTestCasePO execNode) {
        HashMap<String, ICompNamesPairPO> pairs = new HashMap<String, ICompNamesPairPO>();
        for (ICompNamesPairPO pair : execNode.getCompNamesPairs()) {
            pairs.put(pair.getFirstName(), pair);
        }
        ISpecTestCasePO specNode = execNode.getSpecTestCase();
        if (specNode != null) {
            Iterator<INodePO> it = specNode.getAllNodeIter();
            while (it.hasNext()) {
                INodePO child = it.next();
                if (child instanceof IExecTestCasePO) {
                    this.addPropagatedPairs(pairs, (IExecTestCasePO)child);
                    continue;
                }
                if (!(child instanceof ICapPO)) continue;
                this.addCapComponentName(pairs, (ICapPO)child);
            }
        }
        ArrayList<ICompNamesPairPO> pairList = new ArrayList<ICompNamesPairPO>(pairs.values());
        Collections.sort(pairList, new Comparator<ICompNamesPairPO>(){

            @Override
            public int compare(ICompNamesPairPO o1, ICompNamesPairPO o2) {
                return o1.getFirstName().compareTo(o2.getFirstName());
            }
        });
        return pairList;
    }

    public void updateCompNamesPairNew(IExecTestCasePO execNode, ICompNamesPairPO pair, String secondCompName, IWritableComponentNameCache cache) {
        String secondName = cache.getGuidForName(secondCompName);
        if (StringUtils.equals((String)secondName, (String)pair.getSecondName())) {
            return;
        }
        if (secondName == null) {
            IComponentNamePO newComponentNamePO = cache.createComponentNamePO(secondCompName, pair.getType(), ComponentNamesBP.CompNameCreationContext.OVERRIDDEN_NAME);
            newComponentNamePO.setParentProjectId(execNode.getParentProjectId());
            secondName = newComponentNamePO.getGuid();
        }
        cache.changeReuse(pair, pair.getSecondName(), secondName);
        if (execNode.getCompNamesPair(pair.getFirstName()) == null) {
            execNode.addCompNamesPair(pair);
        }
    }

    public CompNameResult findCompName(List<INodePO> treePath, INodePO compNameDefiner, String compNameGuid, IComponentNameCache compNameCache) {
        String currentName = compNameGuid;
        IComponentNamePO currentNamePo = compNameCache.getResCompNamePOByGuid(currentName);
        if (currentNamePo != null) {
            currentName = currentNamePo.getGuid();
        }
        return this.findCompName(treePath, compNameCache, currentName, compNameDefiner);
    }

    private CompNameResult findCompName(List<INodePO> treePath, IComponentNameCache compNameCache, String originalName, INodePO originalCompNameDefiner) {
        String currentName = originalName;
        INodePO compNameDefiner = originalCompNameDefiner;
        ListIterator<INodePO> it = treePath.listIterator(treePath.size());
        while (it.hasPrevious()) {
            INodePO node = it.previous();
            if (!(node instanceof IExecTestCasePO)) continue;
            IExecTestCasePO execNode = (IExecTestCasePO)node;
            ICompNamesPairPO pair = null;
            if (!StringUtils.isEmpty((String)currentName)) {
                pair = execNode.getCompNamesPair(currentName);
            }
            if (pair == null) continue;
            currentName = pair.getSecondName();
            IComponentNamePO currentNamePo = compNameCache.getResCompNamePOByGuid(currentName);
            if (currentNamePo != null) {
                currentName = currentNamePo.getGuid();
            }
            if (pair.isPropagated()) {
                int index = it.previousIndex();
                if (index <= -1) continue;
                compNameDefiner = treePath.get(index);
                continue;
            }
            compNameDefiner = execNode;
            break;
        }
        return new CompNameResult(currentName, compNameDefiner);
    }

    public static void removeIncorrectCompNamePairs(IWritableComponentNameCache cache, INodePO node) {
        if (!(node instanceof ISpecTestCasePO)) {
            return;
        }
        ISpecTestCasePO spec = (ISpecTestCasePO)node;
        CalcTypes.recalculateCompNamePairs(cache, spec);
        Iterator<INodePO> it = spec.getAllNodeIter();
        while (it.hasNext()) {
            INodePO next = it.next();
            if (!(next instanceof IExecTestCasePO)) continue;
            IExecTestCasePO exec = (IExecTestCasePO)next;
            for (ICompNamesPairPO pair : new LinkedList<ICompNamesPairPO>(exec.getCompNamesPairs())) {
                if (CompNamesBP.isValidCompNamePair(pair)) continue;
                exec.removeCompNamesPair(pair.getFirstName());
            }
        }
    }

    public static boolean isValidCompNamePair(ICompNamesPairPO pair) {
        return pair.getType().length() != 0;
    }
}

