/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.providers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.ocl.examples.emf.validation.validity.AbstractNode;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.messages.ValidityMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.SeveritiesDecorator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class NodeLabelProvider
extends ColumnLabelProvider {
    private final @NonNull ILabelProvider labelProvider;
    private final Color validatableColor;
    private final Color constrainingNodeColor;
    private final Font italicFont = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");

    public NodeLabelProvider(@NonNull ILabelProvider labelProvider, Color validatableColor, Color constrainingNodeColor) {
        this.labelProvider = labelProvider;
        this.validatableColor = validatableColor;
        this.constrainingNodeColor = constrainingNodeColor;
    }

    public void addListener(ILabelProviderListener listener) {
        this.labelProvider.addListener(listener);
    }

    protected void appendResourceDiagnostic(@NonNull StringBuilder s, @NonNull Diagnostic diagnostic) {
        boolean isFirst = true;
        List children = diagnostic.getChildren();
        if (!children.isEmpty()) {
            for (Diagnostic child : diagnostic.getChildren()) {
                if (isFirst) {
                    s.append(child.getMessage());
                    isFirst = false;
                    continue;
                }
                s.append("\n" + child.getMessage());
            }
        } else {
            s.append(diagnostic.getMessage());
        }
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        if (element instanceof ResultConstrainingNode) {
            return null;
        }
        if (element instanceof ResultValidatableNode) {
            return this.italicFont;
        }
        if (element instanceof ConstrainingNode) {
            return this.italicFont;
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof ResultConstrainingNode) {
            return this.validatableColor;
        }
        if (element instanceof ResultValidatableNode) {
            return this.constrainingNodeColor;
        }
        if (element instanceof ConstrainingNode) {
            return this.constrainingNodeColor;
        }
        return this.validatableColor;
    }

    public Image getImage(Object element) {
        if (element instanceof ResultValidatableNode) {
            ConstrainingNode constrainingNode = ((ResultValidatableNode)element).getResultConstrainingNode().getParent();
            return this.labelProvider.getImage(constrainingNode != null ? constrainingNode.getConstrainingObject() : null);
        }
        if (element instanceof ResultConstrainingNode) {
            ValidatableNode validatableNode = ((ResultConstrainingNode)element).getResultValidatableNode().getParent();
            return this.labelProvider.getImage((Object)(validatableNode != null ? validatableNode.getConstrainedObject() : null));
        }
        if (element instanceof ConstrainingNode) {
            return this.labelProvider.getImage(((ConstrainingNode)element).getConstrainingObject());
        }
        if (element instanceof ValidatableNode) {
            return this.labelProvider.getImage((Object)((ValidatableNode)element).getConstrainedObject());
        }
        return this.labelProvider.getImage(element);
    }

    protected @NonNull String getResultToolTip(@Nullable Result result) {
        if (result == null) {
            return "No result available";
        }
        if (result.getSeverity() == Severity.OK) {
            return "Successful";
        }
        StringBuilder s = new StringBuilder();
        Object diagnostic = result.getDiagnostic();
        if (diagnostic == null) {
            s.append("<<null diagnostic message>>");
        } else if (diagnostic instanceof Diagnostic) {
            this.appendResourceDiagnostic(s, (Diagnostic)diagnostic);
        } else {
            s.append(String.valueOf(diagnostic));
        }
        Throwable exception = result.getException();
        if (exception != null) {
            s.append("\n" + exception.getClass().getName() + ":\n");
            StringWriter sw = new StringWriter();
            sw.append(s.toString());
            exception.printStackTrace(new PrintWriter(sw));
        }
        return s.toString();
    }

    protected @NonNull String getSummaryToolTip(@NonNull AbstractNode node) {
        Summary summary = new Summary();
        summary.accumulate((EObject)node);
        TreeIterator tit = node.eAllContents();
        while (tit.hasNext()) {
            @NonNull EObject eObject = (EObject)tit.next();
            summary.accumulate(eObject);
        }
        return summary.toString();
    }

    public String getText(Object element) {
        return ((AbstractNode)element).getLabel();
    }

    public Image getToolTipImage(Object object) {
        Object severityImage = SeveritiesDecorator.getSeverityImage(object);
        return ExtendedImageRegistry.INSTANCE.getImage(severityImage);
    }

    public @Nullable String getToolTipText(Object element) {
        if (element instanceof LeafConstrainingNode) {
            LeafConstrainingNode leafConstrainingNode = (LeafConstrainingNode)element;
            return this.getLeafConstrainingNodeHover(leafConstrainingNode, false);
        }
        if (element instanceof ResultConstrainingNode) {
            return this.getResultToolTip(((ResultConstrainingNode)element).getWorstResult());
        }
        if (element instanceof ResultValidatableNode) {
            Result result = ((ResultValidatableNode)element).getWorstResult();
            if (result != null) {
                LeafConstrainingNode leafConstrainingNode = result.getLeafConstrainingNode();
                return this.getLeafConstrainingNodeHover(leafConstrainingNode, true);
            }
            ConstrainingNode contrainingNode = ((ResultValidatableNode)element).getResultConstrainingNode().getParent();
            if (contrainingNode instanceof LeafConstrainingNode) {
                LeafConstrainingNode leafConstrainingNode = (LeafConstrainingNode)contrainingNode;
                return this.getLeafConstrainingNodeHover(leafConstrainingNode, true);
            }
            return this.getResultToolTip(result);
        }
        if (element instanceof AbstractNode) {
            return this.getSummaryToolTip((AbstractNode)element);
        }
        return "Unknown";
    }

    private String getLeafConstrainingNodeHover(LeafConstrainingNode leafConstrainingNode, boolean withDiagnosisMessage) {
        StringBuilder s = new StringBuilder();
        Resource resource = leafConstrainingNode.getConstraintResource();
        s.append("Location: ");
        if (resource != null) {
            s.append(resource.getURI().toString());
        } else {
            s.append(ValidityMessages.ValidityView_Constraints_LabelProvider_NonExistentResource);
        }
        String expression = leafConstrainingNode.getConstraintString();
        s.append("\nExpression: ");
        if (expression != null) {
            s.append(expression);
        } else {
            s.append(ValidityMessages.ValidityView_Constraints_LabelProvider_ExpressionNotAvailable);
        }
        if (withDiagnosisMessage) {
            s.append("\nEvaluation Result: ");
            s.append(this.getResultToolTip(leafConstrainingNode.getWorstResult()));
        }
        s.append("\n");
        s.append(this.getSummaryToolTip((AbstractNode)leafConstrainingNode));
        return s.toString();
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 15000;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (element instanceof ConstrainingNode) {
            return this.labelProvider.isLabelProperty(((ConstrainingNode)element).getConstrainingObject(), property);
        }
        if (element instanceof ValidatableNode) {
            return this.labelProvider.isLabelProperty((Object)((ValidatableNode)element).getConstrainedObject(), property);
        }
        return this.labelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.labelProvider.removeListener(listener);
    }

    protected class Summary {
        private int oks = 0;
        private int infos = 0;
        private int warnings = 0;
        private int errors = 0;
        private int fatals = 0;
        private int defaults = 0;

        protected Summary() {
        }

        public void accumulate(@NonNull EObject eObject) {
            Result worstResult = null;
            if (eObject instanceof ResultValidatableNode) {
                worstResult = ((ResultValidatableNode)eObject).getWorstResult();
            } else if (eObject instanceof ResultConstrainingNode) {
                worstResult = ((ResultConstrainingNode)eObject).getWorstResult();
            }
            if (worstResult != null) {
                Severity severity = worstResult.getSeverity();
                switch (severity) {
                    case OK: {
                        ++this.oks;
                        break;
                    }
                    case INFO: {
                        ++this.infos;
                        break;
                    }
                    case WARNING: {
                        ++this.warnings;
                        break;
                    }
                    case ERROR: {
                        ++this.errors;
                        break;
                    }
                    case FATAL: {
                        ++this.fatals;
                        break;
                    }
                    default: {
                        ++this.defaults;
                    }
                }
            }
        }

        public @NonNull String toString() {
            String separator = ", ";
            StringBuilder s = new StringBuilder();
            s.append(String.valueOf(this.oks) + " ok" + (this.oks != 1 ? "s" : ""));
            if (this.infos > 0) {
                s.append(String.valueOf(separator) + this.infos + " info" + (this.oks != 1 ? "s" : ""));
            }
            if (this.warnings > 0) {
                s.append(String.valueOf(separator) + this.warnings + " warning" + (this.warnings != 1 ? "s" : ""));
            }
            if (this.errors > 0) {
                s.append(String.valueOf(separator) + this.errors + " error" + (this.errors != 1 ? "s" : ""));
            }
            if (this.fatals > 0) {
                s.append(String.valueOf(separator) + this.fatals + " fatal" + (this.fatals != 1 ? "s" : ""));
            }
            if (this.defaults > 0) {
                s.append(String.valueOf(separator) + this.defaults + " other" + (this.defaults != 1 ? "s" : ""));
            }
            return s.toString();
        }
    }
}

