/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.appearance.helper;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.papyrus.infra.emf.appearance.Activator;
import org.eclipse.papyrus.infra.emf.appearance.style.AnnotationStyleProvider;
import org.eclipse.papyrus.infra.emf.appearance.style.AppearanceStyleProvider;

public class AppearanceHelper {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.emf.appearance.styleProvider";
    private static AppearanceStyleProvider styleProvider = AppearanceHelper.findStyleProvider();

    public static boolean showElementIcon(EModelElement modelElement) {
        return styleProvider.showElementIcon(modelElement);
    }

    public static int getQualifiedNameDepth(EModelElement modelElement) {
        return styleProvider.getQualifiedNameDepth(modelElement);
    }

    public static boolean showShadow(EModelElement modelElement) {
        return styleProvider.showShadow(modelElement);
    }

    private static AppearanceStyleProvider findStyleProvider() {
        AppearanceStyleProvider provider = new AnnotationStyleProvider();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int currentPriority = Integer.MAX_VALUE;
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                int priority = Integer.parseInt(e.getAttribute("priority"));
                if (priority < currentPriority) {
                    provider = (AppearanceStyleProvider)e.createExecutableExtension("styleProvider");
                    currentPriority = priority;
                }
            }
            catch (Exception ex) {
                Activator.log.error("The plugin " + e.getContributor() + " contributed an invalid extension for " + EXTENSION_ID, (Throwable)ex);
            }
            ++n2;
        }
        return provider;
    }
}

