/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client;

import java.security.KeyPair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.auth.BuiltinUserAuthFactories;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.keyprovider.KeyIdentityProviderHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface ClientAuthenticationManager
extends KeyIdentityProviderHolder {
    public static final String PREFERRED_AUTHS = "preferred-auths";
    public static final String PASSWORD_PROMPTS = "password-prompts";
    public static final int DEFAULT_PASSWORD_PROMPTS = 3;

    public AuthenticationIdentitiesProvider getRegisteredIdentities();

    public PasswordIdentityProvider getPasswordIdentityProvider();

    public void setPasswordIdentityProvider(PasswordIdentityProvider var1);

    public void addPasswordIdentity(String var1);

    public String removePasswordIdentity(String var1);

    public void addPublicKeyIdentity(KeyPair var1);

    public KeyPair removePublicKeyIdentity(KeyPair var1);

    public ServerKeyVerifier getServerKeyVerifier();

    public void setServerKeyVerifier(ServerKeyVerifier var1);

    public UserInteraction getUserInteraction();

    public void setUserInteraction(UserInteraction var1);

    public List<NamedFactory<UserAuth>> getUserAuthFactories();

    default public String getUserAuthFactoriesNameList() {
        return NamedResource.getNames(this.getUserAuthFactories());
    }

    default public List<String> getUserAuthFactoriesNames() {
        return NamedResource.getNameList(this.getUserAuthFactories());
    }

    public void setUserAuthFactories(List<NamedFactory<UserAuth>> var1);

    default public void setUserAuthFactoriesNameList(String names) {
        this.setUserAuthFactoriesNames(GenericUtils.split(names, ','));
    }

    default public void setUserAuthFactoriesNames(String ... names) {
        this.setUserAuthFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setUserAuthFactoriesNames(Collection<String> names) {
        BuiltinUserAuthFactories.ParseResult result = BuiltinUserAuthFactories.parseFactoriesList(names);
        List<NamedFactory<UserAuth>> factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported cipher factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported cipher factories found: %s", unsupported);
        this.setUserAuthFactories(factories);
    }
}

