/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.choreography;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallChoreography;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.ParticipantBandKind;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2UpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.features.choreography.LayoutChoreographyFeature;
import org.eclipse.bpmn2.modeler.core.features.choreography.Messages;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.AreaContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.util.IColorConstant;

public class UpdateChoreographyParticipantRefsFeature
extends AbstractBpmn2UpdateFeature {
    private static final IPeService peService = Graphiti.getPeService();
    private static final IGaService gaService = Graphiti.getGaService();
    private static final int CORNER_RADIUS = 5;
    private ContainerShape choreographyActivityShape;
    private ChoreographyActivity choreographyActivity;

    public UpdateChoreographyParticipantRefsFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        return ChoreographyUtil.getChoreographyActivityShape(context.getPictogramElement()) != null;
    }

    @Override
    public IReason updateNeeded(IUpdateContext context) {
        this.choreographyActivityShape = ChoreographyUtil.getChoreographyActivityShape(context.getPictogramElement());
        if (this.choreographyActivityShape != null) {
            String activityIds;
            this.choreographyActivity = BusinessObjectUtil.getFirstElementOfType((PictogramElement)this.choreographyActivityShape, ChoreographyActivity.class);
            String shapeIds = ChoreographyUtil.getParticipantRefIds(this.choreographyActivityShape);
            if (!shapeIds.equals(activityIds = ChoreographyUtil.getParticipantRefIds(this.choreographyActivity))) {
                return Reason.createTrueReason((String)Messages.UpdateChoreographyParticipantRefsFeature_Parkticipants_Changed);
            }
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        this.choreographyActivityShape = ChoreographyUtil.getChoreographyActivityShape(context.getPictogramElement());
        this.choreographyActivity = BusinessObjectUtil.getFirstElementOfType((PictogramElement)this.choreographyActivityShape, ChoreographyActivity.class);
        List participants = this.choreographyActivity.getParticipantRefs();
        List<ContainerShape> bandShapes = FeatureSupport.getParticipantBandContainerShapes(this.choreographyActivityShape);
        this.updateParticipantReferences(bandShapes, participants);
        FeatureSupport.setPropertyValue((PropertyContainer)this.choreographyActivityShape, "choreography.activity.participant.ref.ids", ChoreographyUtil.getParticipantRefIds(this.choreographyActivity));
        Participant initiatingParticipant = this.choreographyActivity.getInitiatingParticipantRef();
        String id = initiatingParticipant == null ? "null" : initiatingParticipant.getId();
        FeatureSupport.setPropertyValue((PropertyContainer)this.choreographyActivityShape, "choreography.activity.initiating.participant.ref", id);
        LayoutContext layoutContext = new LayoutContext((PictogramElement)this.choreographyActivityShape);
        LayoutChoreographyFeature feature = new LayoutChoreographyFeature(this.getFeatureProvider());
        feature.layout((ILayoutContext)layoutContext);
        return true;
    }

    private void updateParticipantReferences(List<ContainerShape> currentParticipantContainers, List<Participant> newParticipants) {
        Diagram diagram = peService.getDiagramForShape((Shape)this.choreographyActivityShape);
        BPMNDiagram dia = BusinessObjectUtil.getFirstElementOfType((PictogramElement)diagram, BPMNDiagram.class);
        List diElements = dia.getPlane().getPlaneElement();
        int i = 0;
        while (i < currentParticipantContainers.size()) {
            ContainerShape container = currentParticipantContainers.get(i);
            for (Connection c : peService.getOutgoingConnections((AnchorContainer)container)) {
                AnchorContainer parent = c.getEnd().getParent();
                Shape labelShape = FeatureSupport.getLabelShape((PictogramElement)parent);
                if (labelShape != null) {
                    peService.deletePictogramElement((PictogramElement)labelShape);
                }
                peService.deletePictogramElement((PictogramElement)parent);
            }
            BPMNShape bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, BPMNShape.class);
            diElements.remove(bpmnShape);
            Shape labelShape = FeatureSupport.getLabelShape((PictogramElement)container);
            if (labelShape != null) {
                peService.deletePictogramElement((PictogramElement)labelShape);
            }
            peService.deletePictogramElement((PictogramElement)container);
            ++i;
        }
        GraphicsAlgorithm ga = this.choreographyActivityShape.getGraphicsAlgorithm();
        IDimension size = gaService.calculateSize(ga);
        ArrayList<ContainerShape> newContainers = new ArrayList<ContainerShape>();
        int y = 0;
        boolean first = true;
        ArrayList<InteractionNode> sources = new ArrayList<InteractionNode>();
        if (this.choreographyActivity instanceof ChoreographyTask) {
            for (MessageFlow message : ((ChoreographyTask)this.choreographyActivity).getMessageFlowRef()) {
                sources.add(message.getSourceRef());
            }
        }
        IFeatureProvider fp = this.getFeatureProvider();
        Iterator<Participant> iterator = newParticipants.iterator();
        while (iterator.hasNext()) {
            Participant participant = iterator.next();
            ContainerShape bandShape = peService.createContainerShape(this.choreographyActivityShape, true);
            ParticipantBandKind bandKind = this.getNewParticipantBandKind(this.choreographyActivity, participant, first, !iterator.hasNext());
            boolean multiple = participant.getParticipantMultiplicity() != null && participant.getParticipantMultiplicity().getMaximum() > 1;
            int w = size.getWidth();
            int h = multiple ? 40 : 20;
            BPMNShape bpmnShape = DIUtils.createDIShape((Shape)bandShape, (BaseElement)participant, 0, y + h, w, h, fp, diagram);
            Bpmn2Preferences.getInstance((EObject)this.choreographyActivity).applyBPMNDIDefaults(bpmnShape, null);
            bpmnShape.setChoreographyActivityShape(BusinessObjectUtil.getFirstElementOfType((PictogramElement)this.choreographyActivityShape, BPMNShape.class));
            bpmnShape.setIsMarkerVisible(multiple);
            bpmnShape.setParticipantBandKind(bandKind);
            bpmnShape.setIsMessageVisible(sources.contains(participant));
            this.createParticipantBandContainerShape(bandKind, bandShape, bpmnShape);
            if (multiple) {
                this.drawMultiplicityMarkers(bandShape);
            }
            newContainers.add(bandShape);
            y += h;
            first = false;
        }
        Tuple<List<ContainerShape>, List<ContainerShape>> topAndBottom = FeatureSupport.getTopAndBottomBands(newContainers);
        this.resizeParticipantBandContainerShapes(size.getWidth(), size.getHeight(), topAndBottom.getFirst(), topAndBottom.getSecond());
    }

    private ParticipantBandKind getNewParticipantBandKind(ChoreographyActivity choreography, Participant participant, boolean first, boolean last) {
        boolean initiating;
        boolean bl = initiating = choreography.getInitiatingParticipantRef() != null && choreography.getInitiatingParticipantRef().equals(participant);
        if (first) {
            return initiating ? ParticipantBandKind.TOP_INITIATING : ParticipantBandKind.TOP_NON_INITIATING;
        }
        if (last) {
            return initiating ? ParticipantBandKind.BOTTOM_INITIATING : ParticipantBandKind.BOTTOM_NON_INITIATING;
        }
        return initiating ? ParticipantBandKind.MIDDLE_INITIATING : ParticipantBandKind.MIDDLE_NON_INITIATING;
    }

    private ContainerShape createParticipantBandContainerShape(ParticipantBandKind bandKind, ContainerShape bandShape, BPMNShape bpmnShape) {
        switch (bandKind) {
            case TOP_INITIATING: {
                return this.createTopShape(bandShape, bpmnShape, true);
            }
            case TOP_NON_INITIATING: {
                return this.createTopShape(bandShape, bpmnShape, false);
            }
            case MIDDLE_INITIATING: {
                return this.createMiddleShape(bandShape, bpmnShape, true);
            }
            case MIDDLE_NON_INITIATING: {
                return this.createMiddleShape(bandShape, bpmnShape, false);
            }
            case BOTTOM_INITIATING: {
                return this.createBottomShape(bandShape, bpmnShape, true);
            }
            case BOTTOM_NON_INITIATING: {
                return this.createBottomShape(bandShape, bpmnShape, false);
            }
        }
        return bandShape;
    }

    private ContainerShape createTopShape(ContainerShape bandShape, BPMNShape bpmnShape, boolean initiating) {
        if (bandShape == null) {
            bandShape = peService.createContainerShape(this.choreographyActivityShape, true);
        }
        Bounds bounds = bpmnShape.getBounds();
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)this.choreographyActivityShape);
        RoundedRectangle band = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)bandShape, 5, 5);
        StyleUtil.applyStyle((GraphicsAlgorithm)band, bpmnShape.getBpmnElement());
        band.setStyle(null);
        band.setBackground(initiating ? gaService.manageColor(diagram, IColorConstant.WHITE) : gaService.manageColor(diagram, IColorConstant.LIGHT_GRAY));
        gaService.setLocationAndSize((GraphicsAlgorithm)band, 0, 0, w, h);
        IFeatureProvider fp = this.getFeatureProvider();
        Participant participant = (Participant)bpmnShape.getBpmnElement();
        fp.link((PictogramElement)bandShape, (Object)participant);
        fp.link((PictogramElement)bandShape, (Object)bpmnShape);
        this.addBandLabel(bandShape, w, h);
        Graphiti.getPeCreateService().createChopboxAnchor((AnchorContainer)bandShape);
        FeatureSupport.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band", Boolean.toString(true));
        FeatureSupport.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band.message.visible", Boolean.toString(bpmnShape.isIsMessageVisible()));
        return bandShape;
    }

    private ContainerShape createBottomShape(ContainerShape bandShape, BPMNShape bpmnShape, boolean initiating) {
        if (bandShape == null) {
            bandShape = peService.createContainerShape(this.choreographyActivityShape, true);
        }
        Bounds bounds = bpmnShape.getBounds();
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        ILocation parentLoc = peService.getLocationRelativeToDiagram((Shape)this.choreographyActivityShape);
        int y = (int)bounds.getY() - parentLoc.getY();
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)this.choreographyActivityShape);
        RoundedRectangle band = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)bandShape, 5, 5);
        StyleUtil.applyStyle((GraphicsAlgorithm)band, bpmnShape.getBpmnElement());
        band.setStyle(null);
        band.setBackground(initiating ? gaService.manageColor(diagram, IColorConstant.WHITE) : gaService.manageColor(diagram, IColorConstant.LIGHT_GRAY));
        gaService.setLocationAndSize((GraphicsAlgorithm)band, 0, y, w, h);
        IFeatureProvider fp = this.getFeatureProvider();
        Participant participant = (Participant)bpmnShape.getBpmnElement();
        fp.link((PictogramElement)bandShape, (Object)participant);
        fp.link((PictogramElement)bandShape, (Object)bpmnShape);
        this.addBandLabel(bandShape, w, h);
        Graphiti.getPeCreateService().createChopboxAnchor((AnchorContainer)bandShape);
        FeatureSupport.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band", Boolean.toString(true));
        FeatureSupport.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band.message.visible", Boolean.toString(bpmnShape.isIsMessageVisible()));
        return bandShape;
    }

    private ContainerShape createMiddleShape(ContainerShape bandShape, BPMNShape bpmnShape, boolean initiating) {
        if (bandShape == null) {
            bandShape = peService.createContainerShape(this.choreographyActivityShape, true);
        }
        Bounds bounds = bpmnShape.getBounds();
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        ILocation parentLoc = peService.getLocationRelativeToDiagram((Shape)this.choreographyActivityShape);
        int y = (int)bounds.getY() - parentLoc.getY();
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)this.choreographyActivityShape);
        Rectangle band = gaService.createRectangle((GraphicsAlgorithmContainer)bandShape);
        StyleUtil.applyStyle((GraphicsAlgorithm)band, bpmnShape.getBpmnElement());
        band.setStyle(null);
        band.setBackground(initiating ? gaService.manageColor(diagram, IColorConstant.WHITE) : gaService.manageColor(diagram, IColorConstant.LIGHT_GRAY));
        gaService.setLocationAndSize((GraphicsAlgorithm)band, 0, y, w, h);
        IFeatureProvider fp = this.getFeatureProvider();
        Participant participant = (Participant)bpmnShape.getBpmnElement();
        fp.link((PictogramElement)bandShape, (Object)participant);
        fp.link((PictogramElement)bandShape, (Object)bpmnShape);
        this.addBandLabel(bandShape, w, h);
        Graphiti.getPeCreateService().createChopboxAnchor((AnchorContainer)bandShape);
        FeatureSupport.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band", Boolean.toString(true));
        FeatureSupport.setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band.message.visible", Boolean.toString(bpmnShape.isIsMessageVisible()));
        return bandShape;
    }

    private void addBandLabel(final ContainerShape bandShape, int w, int h) {
        Participant participant = (Participant)BusinessObjectUtil.getFirstBaseElement((PictogramElement)bandShape);
        AreaContext ac = new AreaContext();
        ac.setHeight(h);
        ac.setWidth(w);
        AddContext context = new AddContext((IAreaContext)ac, (Object)bandShape);
        context.setNewObject((Object)participant);
        AddShapeLabelFeature feature = new AddShapeLabelFeature(this.getFeatureProvider()){

            @Override
            protected ContainerShape getTargetContainer(IAddContext context) {
                return bandShape;
            }

            @Override
            protected PictogramElement getLabelOwner(IAddContext context) {
                return bandShape;
            }
        };
        feature.add((IAddContext)context);
    }

    private void resizeParticipantBandContainerShapes(int w, int h, List<ContainerShape> top, List<ContainerShape> bottom) {
        Bounds bounds;
        BPMNShape bpmnShape;
        int x;
        boolean shrink = this.choreographyActivity instanceof CallChoreography;
        int y = shrink ? 2 : 0;
        int n = x = shrink ? 2 : 0;
        if (shrink) {
            w -= 4;
            h -= 2;
        }
        for (ContainerShape container : top) {
            bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, BPMNShape.class);
            bounds = bpmnShape.getBounds();
            int hAcc = (int)bounds.getHeight();
            gaService.setLocationAndSize(container.getGraphicsAlgorithm(), x, y, w, hAcc);
            y += hAcc;
            this.resizeParticipantBandChildren(container, w);
            DIUtils.updateDIShape((PictogramElement)container);
        }
        Collections.reverse(bottom);
        y = h;
        for (ContainerShape container : bottom) {
            bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)container, BPMNShape.class);
            bounds = bpmnShape.getBounds();
            y = (int)((float)y - bounds.getHeight());
            gaService.setLocationAndSize(container.getGraphicsAlgorithm(), x, y, w, (int)bounds.getHeight());
            this.resizeParticipantBandChildren(container, w);
            DIUtils.updateDIShape((PictogramElement)container);
        }
    }

    private void resizeParticipantBandChildren(ContainerShape container, int w) {
        for (Shape s : container.getChildren()) {
            GraphicsAlgorithm ga = s.getGraphicsAlgorithm();
            if (ga instanceof Text) {
                gaService.setSize(ga, w, ga.getHeight());
                continue;
            }
            if (!(ga instanceof Rectangle)) continue;
            gaService.setLocation(ga, w / 2 - ga.getWidth() / 2, ga.getY());
        }
    }

    private void drawMultiplicityMarkers(ContainerShape container) {
        int[][] coorinates;
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)container);
        Shape multiplicityShape = peService.createShape(container, false);
        Rectangle rect = gaService.createInvisibleRectangle((PictogramElement)multiplicityShape);
        IDimension size = gaService.calculateSize(container.getGraphicsAlgorithm());
        int w = 10;
        int h = 10;
        int x = size.getWidth() / 2 - w / 2;
        int y = size.getHeight() - h - 1;
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, x, y, w, h);
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[4];
        nArray[3] = h;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 4;
        nArray2[2] = 4;
        nArray2[3] = h;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 8;
        nArray3[2] = 8;
        nArray3[3] = h;
        nArrayArray[2] = nArray3;
        int[][] nArrayArray2 = coorinates = nArrayArray;
        int n = coorinates.length;
        int n2 = 0;
        while (n2 < n) {
            int[] xy = nArrayArray2[n2];
            Polyline line = gaService.createPolyline((GraphicsAlgorithmContainer)rect, xy);
            line.setLineWidth(Integer.valueOf(2));
            line.setForeground(gaService.manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
            ++n2;
        }
    }
}

