/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.impl.api;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.dao.ACDAOFacade;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESGroupImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESUserImpl;
import org.eclipse.emf.emfstore.server.model.ESGroup;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitRepository;
import org.eclipse.emf.emfstore.server.model.ESProjectHistory;
import org.eclipse.emf.emfstore.server.model.ESUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESOrgUnitRepositoryImpl
implements ESOrgUnitRepository {
    private final ACDAOFacade facade;

    public ESOrgUnitRepositoryImpl(ACDAOFacade facade) {
        this.facade = facade;
    }

    @Override
    public Set<ESUser> getUsers() {
        return new LinkedHashSet<ESUser>(APIUtil.mapToAPI(ESUser.class, this.facade.getUsers()));
    }

    @Override
    public Set<ESGroup> getGroups() {
        return new LinkedHashSet<ESGroup>(APIUtil.mapToAPI(ESGroup.class, this.facade.getGroups()));
    }

    @Override
    public List<ESProjectHistory> getProjects() {
        return APIUtil.toExternal(this.facade.getProjects());
    }

    @Override
    public void removeGroup(ESGroup group) {
        this.facade.remove((ACGroup)((ESGroupImpl)ESGroupImpl.class.cast(group)).toInternalAPI());
    }

    @Override
    public void removeUser(ESUser user) {
        this.facade.remove((ACUser)((ESUserImpl)ESUserImpl.class.cast(user)).toInternalAPI());
    }

    @Override
    public void addUser(ESUser user) {
        this.facade.add((ACUser)((ESUserImpl)ESUserImpl.class.cast(user)).toInternalAPI());
    }

    @Override
    public void addGroup(ESGroup group) {
        this.facade.add((ACGroup)((ESGroupImpl)ESGroupImpl.class.cast(group)).toInternalAPI());
    }

    @Override
    public void save() throws IOException {
        this.facade.save();
    }
}

