/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.epp.logging.aeri.core.ISendOptions;
import org.eclipse.epp.logging.aeri.core.Severity;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Send Options</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.SendOptionsImpl#getComment <em>Comment</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.SendOptionsImpl#getSeverity <em>Severity</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.SendOptionsImpl#getEnabledProcessors <em>Enabled Processors</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SendOptionsImpl extends UserSettingsImpl implements ISendOptions {
	/**
	 * The default value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
	protected static final String COMMENT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getComment() <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getComment()
	 * @generated
	 * @ordered
	 */
	protected String comment = COMMENT_EDEFAULT;

	/**
	 * The default value of the '{@link #getSeverity() <em>Severity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSeverity()
	 * @generated
	 * @ordered
	 */
	protected static final Severity SEVERITY_EDEFAULT = Severity.UNKNOWN;

	/**
	 * The cached value of the '{@link #getSeverity() <em>Severity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSeverity()
	 * @generated
	 * @ordered
	 */
	protected Severity severity = SEVERITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getEnabledProcessors() <em>Enabled Processors</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnabledProcessors()
	 * @generated
	 * @ordered
	 */
	protected EList<IReportProcessor> enabledProcessors;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SendOptionsImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IModelPackage.Literals.SEND_OPTIONS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getComment() {
		return comment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setComment(String newComment) {
		String oldComment = comment;
		comment = newComment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.SEND_OPTIONS__COMMENT, oldComment, comment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Severity getSeverity() {
		return severity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSeverity(Severity newSeverity) {
		Severity oldSeverity = severity;
		severity = newSeverity == null ? SEVERITY_EDEFAULT : newSeverity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.SEND_OPTIONS__SEVERITY, oldSeverity, severity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<IReportProcessor> getEnabledProcessors() {
		if (enabledProcessors == null) {
			enabledProcessors = new EDataTypeUniqueEList<IReportProcessor>(IReportProcessor.class, this, IModelPackage.SEND_OPTIONS__ENABLED_PROCESSORS);
		}
		return enabledProcessors;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IModelPackage.SEND_OPTIONS__COMMENT:
				return getComment();
			case IModelPackage.SEND_OPTIONS__SEVERITY:
				return getSeverity();
			case IModelPackage.SEND_OPTIONS__ENABLED_PROCESSORS:
				return getEnabledProcessors();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IModelPackage.SEND_OPTIONS__COMMENT:
				setComment((String)newValue);
				return;
			case IModelPackage.SEND_OPTIONS__SEVERITY:
				setSeverity((Severity)newValue);
				return;
			case IModelPackage.SEND_OPTIONS__ENABLED_PROCESSORS:
				getEnabledProcessors().clear();
				getEnabledProcessors().addAll((Collection<? extends IReportProcessor>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IModelPackage.SEND_OPTIONS__COMMENT:
				setComment(COMMENT_EDEFAULT);
				return;
			case IModelPackage.SEND_OPTIONS__SEVERITY:
				setSeverity(SEVERITY_EDEFAULT);
				return;
			case IModelPackage.SEND_OPTIONS__ENABLED_PROCESSORS:
				getEnabledProcessors().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IModelPackage.SEND_OPTIONS__COMMENT:
				return COMMENT_EDEFAULT == null ? comment != null : !COMMENT_EDEFAULT.equals(comment);
			case IModelPackage.SEND_OPTIONS__SEVERITY:
				return severity != SEVERITY_EDEFAULT;
			case IModelPackage.SEND_OPTIONS__ENABLED_PROCESSORS:
				return enabledProcessors != null && !enabledProcessors.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (comment: ");
		result.append(comment);
		result.append(", severity: ");
		result.append(severity);
		result.append(", enabledProcessors: ");
		result.append(enabledProcessors);
		result.append(')');
		return result.toString();
	}

} //SendOptionsImpl
