/**
 */
package org.eclipse.gef.dot.internal.language.fontname.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.gef.dot.internal.language.fontname.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class FontnameFactoryImpl extends EFactoryImpl implements FontnameFactory
{
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static FontnameFactory init()
	{
		try
		{
			FontnameFactory theFontnameFactory = (FontnameFactory)EPackage.Registry.INSTANCE.getEFactory(FontnamePackage.eNS_URI);
			if (theFontnameFactory != null)
			{
				return theFontnameFactory;
			}
		}
		catch (Exception exception)
		{
			EcorePlugin.INSTANCE.log(exception);
		}
		return new FontnameFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FontnameFactoryImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass)
	{
		switch (eClass.getClassifierID())
		{
			case FontnamePackage.POST_SCRIPT_FONT_NAME: return createPostScriptFontName();
			case FontnamePackage.PANGO_FONT_NAME: return createPangoFontName();
			case FontnamePackage.STYLE_OPTIONS_ELEMENT: return createStyleOptionsElement();
			case FontnamePackage.STYLE_OPTION: return createStyleOption();
			case FontnamePackage.VARIANT_OPTION: return createVariantOption();
			case FontnamePackage.WEIGHT_OPTION: return createWeightOption();
			case FontnamePackage.STRETCH_OPTION: return createStretchOption();
			case FontnamePackage.GRAVITY_OPTION: return createGravityOption();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue)
	{
		switch (eDataType.getClassifierID())
		{
			case FontnamePackage.STYLE:
				return createStyleFromString(eDataType, initialValue);
			case FontnamePackage.VARIANT:
				return createVariantFromString(eDataType, initialValue);
			case FontnamePackage.WEIGHT:
				return createWeightFromString(eDataType, initialValue);
			case FontnamePackage.STRETCH:
				return createStretchFromString(eDataType, initialValue);
			case FontnamePackage.GRAVITY:
				return createGravityFromString(eDataType, initialValue);
			case FontnamePackage.POST_SCRIPT_FONT_ALIAS:
				return createPostScriptFontAliasFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue)
	{
		switch (eDataType.getClassifierID())
		{
			case FontnamePackage.STYLE:
				return convertStyleToString(eDataType, instanceValue);
			case FontnamePackage.VARIANT:
				return convertVariantToString(eDataType, instanceValue);
			case FontnamePackage.WEIGHT:
				return convertWeightToString(eDataType, instanceValue);
			case FontnamePackage.STRETCH:
				return convertStretchToString(eDataType, instanceValue);
			case FontnamePackage.GRAVITY:
				return convertGravityToString(eDataType, instanceValue);
			case FontnamePackage.POST_SCRIPT_FONT_ALIAS:
				return convertPostScriptFontAliasToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PostScriptFontName createPostScriptFontName()
	{
		PostScriptFontNameImplCustom postScriptFontName = new PostScriptFontNameImplCustom();
		return postScriptFontName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PangoFontName createPangoFontName()
	{
		PangoFontNameImplCustom pangoFontName = new PangoFontNameImplCustom();
		return pangoFontName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StyleOptionsElement createStyleOptionsElement()
	{
		StyleOptionsElementImpl styleOptionsElement = new StyleOptionsElementImpl();
		return styleOptionsElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StyleOption createStyleOption()
	{
		StyleOptionImpl styleOption = new StyleOptionImpl();
		return styleOption;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public VariantOption createVariantOption()
	{
		VariantOptionImpl variantOption = new VariantOptionImpl();
		return variantOption;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public WeightOption createWeightOption()
	{
		WeightOptionImpl weightOption = new WeightOptionImpl();
		return weightOption;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StretchOption createStretchOption()
	{
		StretchOptionImpl stretchOption = new StretchOptionImpl();
		return stretchOption;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GravityOption createGravityOption()
	{
		GravityOptionImpl gravityOption = new GravityOptionImpl();
		return gravityOption;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Style createStyleFromString(EDataType eDataType, String initialValue)
	{
		Style result = Style.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertStyleToString(EDataType eDataType, Object instanceValue)
	{
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Variant createVariantFromString(EDataType eDataType, String initialValue)
	{
		Variant result = Variant.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertVariantToString(EDataType eDataType, Object instanceValue)
	{
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Weight createWeightFromString(EDataType eDataType, String initialValue)
	{
		Weight result = Weight.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertWeightToString(EDataType eDataType, Object instanceValue)
	{
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Stretch createStretchFromString(EDataType eDataType, String initialValue)
	{
		Stretch result = Stretch.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertStretchToString(EDataType eDataType, Object instanceValue)
	{
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Gravity createGravityFromString(EDataType eDataType, String initialValue)
	{
		Gravity result = Gravity.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertGravityToString(EDataType eDataType, Object instanceValue)
	{
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PostScriptFontAlias createPostScriptFontAliasFromString(EDataType eDataType, String initialValue)
	{
		return (PostScriptFontAlias)super.createFromString(eDataType, initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertPostScriptFontAliasToString(EDataType eDataType, Object instanceValue)
	{
		return super.convertToString(eDataType, instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FontnamePackage getFontnamePackage()
	{
		return (FontnamePackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static FontnamePackage getPackage()
	{
		return FontnamePackage.eINSTANCE;
	}

} //FontnameFactoryImpl
