/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.jonas;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.libra.framework.core.FrameworkDelegate;
import org.eclipse.libra.framework.core.IOSGIFrameworkWorkingCopy;
import org.eclipse.libra.framework.jonas.IJonasFramework;
import org.eclipse.libra.framework.jonas.IJonasVersionHandler;
import org.eclipse.libra.framework.jonas.JonasPlugin;
import org.eclipse.libra.framework.jonas.Messages;
import org.eclipse.wst.server.core.IRuntimeType;

public class JonasFramework
extends FrameworkDelegate
implements IOSGIFrameworkWorkingCopy,
IJonasFramework {
    public IJonasVersionHandler getVersionHandler() {
        IRuntimeType type = this.getRuntime().getRuntimeType();
        return JonasPlugin.getJonasVersionHandler(type.getId());
    }

    public List getFrameworkClasspath(IPath configPath) {
        IPath installPath = this.getRuntime().getLocation();
        if (!installPath.isAbsolute()) {
            try {
                String installLoc = new File(installPath.toOSString()).getCanonicalPath();
                installPath = new Path(installLoc);
            }
            catch (IOException iOException) {}
        }
        return this.getVersionHandler().getFrameworkClasspath(installPath, configPath);
    }

    public IStatus verifyLocation() {
        return this.getVersionHandler().verifyInstallPath(this.getRuntime().getLocation());
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        status = this.verifyLocation();
        if (!status.isOK()) {
            return status;
        }
        if (this.getRuntime().getLocation().hasTrailingSeparator()) {
            return new Status(4, "org.eclipse.libra.framework.jonas", 0, Messages.errorInstallDirTrailingSlash, null);
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "org.eclipse.libra.framework.jonas", 0, Messages.errorJRE, null);
        }
        File f = this.getRuntime().getLocation().append("conf").toFile();
        File[] conf = f.listFiles();
        if (conf != null) {
            int size = conf.length;
            int i = 0;
            while (i < size) {
                if (!f.canRead()) {
                    return new Status(2, "org.eclipse.libra.framework.jonas", 0, Messages.warningCantReadConfig, null);
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }
}

