/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.Geometry;
import org.eclipse.m2e.editor.xml.PomHyperlinkDetector;
import org.eclipse.m2e.editor.xml.PomTextHover;
import org.eclipse.m2e.editor.xml.internal.MarkerHoverControl;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public final class FormHoverProvider {
    public static Execute createHoverRunnable(Shell parentShell, IMarker[] markers, ISourceViewer sourceViewer) {
        if (markers.length > 0) {
            return position -> {
                List<IMarker> markersSet = Arrays.asList(markers);
                PomTextHover.CompoundRegion compound = new PomTextHover.CompoundRegion((ITextViewer)sourceViewer, 0);
                Iterator it = sourceViewer.getAnnotationModel().getAnnotationIterator();
                while (it.hasNext()) {
                    Annotation ann = (Annotation)it.next();
                    if (!(ann instanceof MarkerAnnotation)) continue;
                    MarkerAnnotation mann = (MarkerAnnotation)ann;
                    if (markersSet.contains(mann.getMarker())) {
                        // empty if block
                    }
                    compound.addRegion(new PomHyperlinkDetector.MarkerRegion(0, 0, mann));
                }
                MarkerHoverControl mhc = new MarkerHoverControl(parentShell);
                Display fDisplay = mhc.getMyShell().getDisplay();
                Listener displayListener = event -> {
                    MarkerHoverControl iControl;
                    if (event.type == 5) {
                        IInformationControlExtension3 iControl3;
                        Rectangle controlBounds;
                        if (!(event.widget instanceof Control) || event.widget.isDisposed()) {
                            return;
                        }
                        MarkerHoverControl infoControl = mhc;
                        if (infoControl != null && !infoControl.isFocusControl() && infoControl instanceof IInformationControlExtension3 && (controlBounds = (iControl3 = (IInformationControlExtension3)infoControl).getBounds()) != null) {
                            Point mouseLoc = event.display.map((Control)event.widget, null, event.x, event.y);
                            int margin = 20;
                            Geometry.expand((Rectangle)controlBounds, (int)margin, (int)margin, (int)margin, (int)margin);
                            if (!controlBounds.contains(mouseLoc)) {
                                mhc.setVisible(false);
                            }
                        }
                    } else if (event.type == 16 && (iControl = mhc) != null && !iControl.isFocusControl()) {
                        mhc.setVisible(false);
                    }
                };
                mhc.setLocation(new Point(position.x, position.y));
                mhc.setSizeConstraints(400, 400);
                mhc.setInput(compound);
                Point hint = mhc.computeSizeHint();
                mhc.setSize(hint.x, Math.min(hint.y, 400));
                if (!fDisplay.getBounds().contains(position.x + hint.x, position.y)) {
                    mhc.setLocation(new Point(position.x - (position.x + hint.x - fDisplay.getBounds().width), position.y));
                }
                if (!fDisplay.isDisposed()) {
                    fDisplay.addFilter(5, displayListener);
                    fDisplay.addFilter(16, displayListener);
                }
                mhc.addDisposeListener(e -> {
                    fDisplay.removeFilter(5, displayListener);
                    fDisplay.removeFilter(16, displayListener);
                });
                mhc.setVisible(true);
            };
        }
        return null;
    }

    public static interface Execute {
        public void run(Point var1);
    }
}

