/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.Iterator;
import java.util.function.Predicate;
import org.eclipse.net4j.util.collection.AbstractIterator;

public abstract class AbstractFilteredIterator<T>
extends AbstractIterator<T> {
    private Iterator<T> delegate;

    public AbstractFilteredIterator(Iterator<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    protected Object computeNextElement() {
        while (this.delegate.hasNext()) {
            T element = this.delegate.next();
            if (!this.isValid(element)) continue;
            return element;
        }
        return END_OF_DATA;
    }

    protected abstract boolean isValid(T var1);

    public static class Predicated<T>
    extends AbstractFilteredIterator<T> {
        private final Predicate<? super T> predicate;

        public Predicated(Iterator<T> delegate, Predicate<? super T> predicate) {
            super(delegate);
            this.predicate = predicate;
        }

        public Predicated(Predicate<? super T> predicate, Iterator<T> delegate) {
            super(delegate);
            this.predicate = predicate;
        }

        public Predicate<? super T> getPredicate() {
            return this.predicate;
        }

        @Override
        protected boolean isValid(T element) {
            return this.predicate.test(element);
        }
    }
}

