/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.wizards.listeners;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.ui.wizards.NewTeamWizardPage;
import org.eclipse.objectteams.otdt.internal.ui.wizards.NewTypeWizardPage;
import org.eclipse.objectteams.otdt.internal.ui.wizards.OTNewWizardMessages;
import org.eclipse.objectteams.otdt.internal.ui.wizards.listeners.NewTypeWizardPageListener;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;

public class NewTeamWizardPageListener
extends NewTypeWizardPageListener {
    public NewTeamWizardPageListener(NewTeamWizardPage observedPage) {
        super(observedPage);
    }

    @Override
    protected IType chooseSuperType() {
        IPackageFragmentRoot root = this.getObservedPage().getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        return NewTeamWizardPageListener.chooseTeam((IJavaElement)root.getJavaProject(), this.getObservedPage().getShell(), this.getObservedPage().getWizard().getContainer(), OTNewWizardMessages.NewTeamWizardPage_ChooseSuperTypeDialog_title, OTNewWizardMessages.NewTeamWizardPage_ChooseSuperTypeDialog_description, this.getObservedPage().getSuperTypeName());
    }

    @Override
    public IStatus[] getRelevantStates(boolean ignoreFirstField) {
        if (ignoreFirstField) {
            return new IStatus[]{this.getObservedPage().getContainerStatus(), this._packageStatus, this._enclosingTeamStatus, this._modifierStatus, this._superTypeStatus, this._superInterfacesStatus};
        }
        return new IStatus[]{this.getObservedPage().getContainerStatus(), this._packageStatus, this._enclosingTeamStatus, this._typeNameStatus, this._modifierStatus, this._superTypeStatus, this._superInterfacesStatus};
    }

    @Override
    protected IStatus validateEnclosingType() {
        IStatus status = super.validateEnclosingType();
        if (status.getSeverity() == 4) {
            this.getObservedPage().getInlineSelectionDialogField().setSelection(false);
            this.getObservedPage().getInlineSelectionDialogField().setEnabled(false);
        }
        this.handleAccessModifierButtons();
        this.getObservedPage().updateEnableState();
        return status;
    }

    @Override
    void validateSuperClass(StatusInfo status) {
        super.validateSuperClass(status);
        IType superType = this.getObservedPage().getSuperType();
        if (superType == null) {
            return;
        }
        IOTType superTeam = OTModelManager.getOTElement((IType)superType);
        if (!superType.getFullyQualifiedName().equals(String.valueOf(IOTConstants.STR_ORG_OBJECTTEAMS_TEAM)) && superTeam != null) {
            SelectionButtonDialogFieldGroup bindingEditorGroup = ((NewTeamWizardPage)this.getObservedPage()).getBindingEditorButtons();
            bindingEditorGroup.setEnabled(true);
        }
    }

    @Override
    protected void handleEnclosingTypeDialogFieldIsEmpty(StatusInfo status) {
        this.getObservedPage().getPackageDialogField().setEnabled(true);
        this.getObservedPage().getInlineSelectionDialogField().setSelection(false);
        this.getObservedPage().getInlineSelectionDialogField().setEnabled(false);
        super.handleEnclosingTypeDialogFieldIsEmpty(status);
    }

    protected void handleAccessModifierButtons() {
        SelectionButtonDialogFieldGroup modifierButtons = this.getObservedPage().getAccessModifierButtons();
        if (this.getObservedPage().getEnclosingTypeName().equals("")) {
            int modifiers = this.getObservedPage().getModifiers();
            if (Flags.isPrivate((int)modifiers) || Flags.isProtected((int)modifiers)) {
                modifierButtons.setSelection(2, false);
                modifierButtons.setSelection(3, false);
                modifierButtons.setSelection(0, true);
            }
            modifierButtons.enableSelectionButton(2, false);
            modifierButtons.enableSelectionButton(3, false);
        } else {
            modifierButtons.enableSelectionButton(2, true);
            modifierButtons.enableSelectionButton(3, true);
        }
    }

    @Override
    protected IStatus validatePackage() {
        IPackageFragmentRoot root;
        StatusInfo status = new StatusInfo();
        this.updatePackageStatusLabel();
        this.getObservedPage().getPackageDialogField().enableButton(this.getObservedPage().getPackageFragmentRoot() != null);
        String packName = this.getObservedPage().getPackageName();
        if (packName.trim().length() > 0) {
            IStatus val = NewTypeWizardPage.validatePackageName(packName, this.getObservedPage().getJavaProject());
            if (val.getSeverity() == 4) {
                status.setError(Messages.format((String)NewWizardMessages.NewTypeWizardPage_error_InvalidPackageName, (Object)val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(Messages.format((String)NewWizardMessages.NewTypeWizardPage_warning_DiscouragedPackageName, (Object)val.getMessage()));
            }
        }
        if ((root = this.getObservedPage().getPackageFragmentRoot()) != null) {
            if (root.getJavaProject().exists() && packName.trim().length() > 0) {
                try {
                    IPath packagePath;
                    IPath rootPath = root.getPath();
                    IPath outputPath = root.getJavaProject().getOutputLocation();
                    if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = rootPath.append(packName.replace('.', '/')))) {
                        status.setError(NewWizardMessages.NewTypeWizardPage_error_ClashOutputLocation);
                        return status;
                    }
                }
                catch (JavaModelException ex) {
                    OTDTUIPlugin.logException("", ex);
                }
            }
            this.getObservedPage().setPackageFragment(root.getPackageFragment(packName), true);
        } else {
            status.setError("");
        }
        return status;
    }

    protected void updatePackageStatusLabel() {
        String packName = this.getObservedPage().getPackageName();
        if (packName.length() == 0) {
            this.getObservedPage().getPackageDialogField().setStatus(NewWizardMessages.NewTypeWizardPage_default);
        } else {
            this.getObservedPage().getPackageDialogField().setStatus("");
        }
    }
}

