/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.Binding;
import org.eclipse.objectteams.otredyn.runtime.IBinding;
import org.eclipse.objectteams.otredyn.runtime.IBoundClass;
import org.eclipse.objectteams.otredyn.runtime.IBoundTeam;
import org.eclipse.objectteams.otredyn.runtime.IClassIdentifierProvider;
import org.eclipse.objectteams.otredyn.runtime.IClassRepository;

public abstract class AbstractTeam
extends AbstractBoundClass
implements IBoundTeam {
    private Set<IBinding> bindings = new TreeSet<IBinding>();
    private int highestAccessId;

    protected AbstractTeam(@NonNull String name, String id, ClassLoader loader) {
        super(name, id, loader);
    }

    public void addBinding(Binding binding) {
        this.bindings.add(binding);
    }

    public Collection<IBinding> getBindings() {
        this.parseBytecode();
        return this.bindings;
    }

    @Override
    public AbstractTeam getSuperclass() {
        return (AbstractTeam)super.getSuperclass();
    }

    public void recordAccessId(int accessId) {
        this.highestAccessId = Math.max(this.highestAccessId, accessId);
    }

    public int getHighestAccessId() {
        return this.highestAccessId;
    }

    private List<String> getTSubRoles(String simpleRoleName) {
        ArrayList<String> result = new ArrayList<String>();
        for (AbstractBoundClass subTeam : this.subclasses.keySet()) {
            if (subTeam.isAnonymous()) continue;
            result.add(String.valueOf(subTeam.getName()) + '$' + simpleRoleName);
        }
        return result;
    }

    public List<IBoundClass> getTSubsOfThis(IClassRepository classRepository, IClassIdentifierProvider idProvider) {
        String name = this.getName();
        int dollar = name.lastIndexOf(36);
        if (dollar == -1) {
            return Collections.emptyList();
        }
        String teamName = name.substring(0, dollar);
        IBoundTeam myTeam = classRepository.getTeam(teamName.replace('/', '.'), teamName.replace('.', '/'), this.loader);
        List<String> tsubRoleNames = ((AbstractTeam)myTeam).getTSubRoles(name.substring(dollar + 1));
        ArrayList<IBoundClass> tsubBases = new ArrayList<IBoundClass>();
        for (String tsubRoleName : tsubRoleNames) {
            tsubBases.add(classRepository.getBoundClass(tsubRoleName.replace('/', '.'), tsubRoleName.replace('.', '/'), this.loader));
        }
        return tsubBases;
    }

    protected abstract void setBytecode(byte[] var1);
}

