/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.services.IDisposable;

public class MultipleValueWidget
implements ISelectionChangedListener,
IDoubleClickListener,
IElementSelectionListener,
SelectionListener,
IDisposable {
    protected IElementSelector selector;
    protected Composite rightButtonsSection;
    protected TreeViewer selectedElementsViewer;
    protected Tree selectedElements;
    protected Button create;
    protected Button delete;
    protected Button up;
    protected Button down;
    protected ILabelProvider labelProvider;
    protected final Collection<Object> allElements;
    protected boolean unique;
    protected boolean ordered;
    protected ReferenceValueFactory factory;
    protected Object contextElement;
    protected Set<Object> newObjects = new HashSet<Object>();
    protected int upperBound;
    protected List<?> initialSelection;

    public MultipleValueWidget(IElementSelector selector) {
        this(selector, false, false);
    }

    public MultipleValueWidget(IElementSelector selector, boolean unique) {
        this(selector, unique, false);
    }

    public MultipleValueWidget(IElementSelector selector, boolean unique, boolean ordered) {
        this(selector, unique, false, -1);
    }

    public MultipleValueWidget(IElementSelector selector, boolean unique, boolean ordered, int upperBound) {
        Assert.isNotNull((Object)selector, (String)"The element selector should be defined");
        this.selector = selector;
        this.allElements = unique ? new LinkedHashSet() : new LinkedList();
        this.unique = unique;
        this.ordered = ordered;
        this.upperBound = upperBound;
        selector.addElementSelectionListener(this);
        this.init();
    }

    protected void init() {
    }

    public final Composite create(Composite composite) {
        Composite parent = this.createContents(composite);
        this.updateControls();
        return parent;
    }

    protected Composite createContents(Composite parent) {
        Layout parentLayout = parent.getLayout();
        GridLayout layout = null;
        if (parentLayout instanceof GridLayout) {
            layout = (GridLayout)parentLayout;
        } else {
            parent = new Composite(parent, 0);
            layout = new GridLayout();
            parent.setLayout((Layout)layout);
        }
        this.createSections(parent);
        this.allElements.clear();
        this.allElements.addAll(this.getInitialElementSelections());
        return parent;
    }

    protected void createSections(Composite parent) {
        Composite selectedPane = new Composite(parent, 0);
        selectedPane.setLayout((Layout)new GridLayout(2, false));
        selectedPane.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createListSection(selectedPane);
        this.createRightButtonsSection(selectedPane);
    }

    public void setInitialSelections(List<?> selectedElements) {
        this.initialSelection = selectedElements;
        this.allElements.clear();
        this.allElements.addAll(this.getInitialElementSelections());
    }

    private Collection<? extends Object> getInitialElementSelections() {
        if (this.initialSelection == null) {
            return Collections.emptyList();
        }
        return this.initialSelection;
    }

    protected void createListSection(Composite parent) {
        this.selectedElements = new Tree(parent, 2818);
        GridData data = new GridData(4, 4, true, true);
        this.selectedElements.setLayoutData((Object)data);
        this.selectedElementsViewer = new TreeViewer(this.selectedElements);
        this.selectedElementsViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.selectedElementsViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.selectedElementsViewer.setContentProvider(this.createListSectionContentProvider());
        if (this.labelProvider != null) {
            this.selectedElementsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.selectedElementsViewer.setInput(this.allElements);
        this.selector.setSelectedElements(this.allElements.toArray());
    }

    protected IContentProvider createListSectionContentProvider() {
        return CollectionContentProvider.instance;
    }

    protected void createRightButtonsSection(Composite parent) {
        this.rightButtonsSection = new Composite(parent, 0);
        this.rightButtonsSection.setLayout((Layout)new GridLayout(1, true));
        this.up = new Button(this.rightButtonsSection, 8);
        this.up.setImage(Activator.getDefault().getImage("/icons/Up_12x12.gif"));
        this.up.addSelectionListener((SelectionListener)this);
        this.up.setToolTipText(Messages.MultipleValueEditor_MoveSelectedElementsUp);
        this.down = new Button(this.rightButtonsSection, 8);
        this.down.setImage(Activator.getDefault().getImage("/icons/Down_12x12.gif"));
        this.down.addSelectionListener((SelectionListener)this);
        this.down.setToolTipText(Messages.MultipleValueEditor_MoveSelectedElementsDown);
        this.create = new Button(this.rightButtonsSection, 8);
        this.create.setImage(Activator.getDefault().getImage("/icons/Add_12x12.gif"));
        this.create.addSelectionListener((SelectionListener)this);
        this.create.setToolTipText(Messages.MultipleValueSelectorDialog_CreateNewElement);
        this.delete = new Button(this.rightButtonsSection, 8);
        this.delete.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.delete.addSelectionListener((SelectionListener)this);
        this.delete.setToolTipText(Messages.MultipleValueSelectorDialog_DeleteNewElement);
        this.delete.setEnabled(false);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.up) {
            this.upAction();
        } else if (e.widget == this.down) {
            this.downAction();
        } else if (e.widget == this.create) {
            this.createAction();
        } else if (e.widget == this.delete) {
            this.deleteAction();
        }
        this.updateControls();
    }

    public void setFactory(ReferenceValueFactory factory) {
        this.factory = factory;
        this.updateControls();
    }

    protected void upAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        LinkedList<Object> list = new LinkedList<Object>(this.allElements);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            int oldIndex = list.indexOf(o);
            if (oldIndex > 0) {
                this.move(list, oldIndex, oldIndex - 1);
            }
            ++n2;
        }
        this.allElements.clear();
        this.allElements.addAll(list);
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.selectedElementsViewer.setSelection((ISelection)selectionCopy);
        this.selectedElementsViewer.refresh();
    }

    protected void downAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        LinkedList<Object> list = new LinkedList<Object>(this.allElements);
        int maxIndex = list.size() - 1;
        Object[] selectionArray = selection.toArray();
        int i = selectionArray.length - 1;
        while (i >= 0) {
            Object o = selectionArray[i];
            int oldIndex = list.indexOf(o);
            if (oldIndex < maxIndex) {
                this.move(list, oldIndex, oldIndex + 1);
            }
            --i;
        }
        this.allElements.clear();
        this.allElements.addAll(list);
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.selectedElementsViewer.setSelection((ISelection)selectionCopy);
        this.selectedElementsViewer.refresh();
    }

    protected void createAction() {
        Object newObject;
        if (this.factory == null) {
            return;
        }
        try {
            newObject = this.factory.createObject((Control)this.create, this.contextElement);
        }
        catch (OperationCanceledException e) {
            newObject = null;
        }
        if (newObject == null) {
            return;
        }
        this.newObjects.add(newObject);
        this.selector.newObjectCreated(newObject);
        Object[] createdObjects = new Object[]{newObject};
        this.addElements(createdObjects);
        this.selector.setSelectedElements(this.allElements.toArray());
    }

    private void move(List<Object> list, int oldIndex, int newIndex) {
        int size = list.size();
        if (oldIndex < 0 || oldIndex >= size) {
            throw new IndexOutOfBoundsException("oldIndex: " + oldIndex + ", size:" + size);
        }
        if (newIndex < 0 || newIndex >= size) {
            throw new IndexOutOfBoundsException("newIndex: " + newIndex + ", size:" + size);
        }
        Object element = list.remove(oldIndex);
        list.add(newIndex, element);
    }

    protected void removeAction() {
        if (this.canRemove()) {
            IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.allElements.remove(element);
                ++n2;
            }
            this.selector.setSelectedElements(this.allElements.toArray());
            this.selectedElementsViewer.setSelection(null);
            this.selectedElementsViewer.refresh();
        }
    }

    protected void deleteAction() {
        ISelection selection = this.selectedElementsViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Iterator selectedObjects = ((IStructuredSelection)selection).iterator();
            ArrayList removedObjects = new ArrayList();
            while (selectedObjects.hasNext()) {
                Object selectedObject = selectedObjects.next();
                if (this.newObjects.contains(selectedObject)) {
                    this.newObjects.remove(selectedObject);
                }
                removedObjects.add(selectedObject);
            }
            this.removeElements(removedObjects.toArray());
            this.selector.setSelectedElements(this.allElements.toArray());
        }
    }

    @Override
    public void addElements(Object[] elements) {
        if (elements != null && elements.length > 0) {
            this.allElements.addAll(Arrays.asList(elements));
            this.selectedElementsViewer.refresh();
        }
    }

    public void removeElements(Object[] elements) {
        if (elements != null && elements.length > 0) {
            this.allElements.removeAll(Arrays.asList(elements));
            this.selectedElementsViewer.refresh();
        }
    }

    public List<Object> getSelection() {
        if (this.factory != null) {
            LinkedList<Object> objectsToValidate = new LinkedList<Object>();
            for (Object object : this.newObjects) {
                if (!this.allElements.contains(object)) continue;
                objectsToValidate.add(object);
            }
            this.factory.validateObjects(objectsToValidate);
            this.selector.clearTemporaryElements();
        }
        return new LinkedList<Object>(this.allElements);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
        this.updateControls();
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
        this.updateControls();
    }

    public void updateControls() {
        this.updateControl((Control)this.up, this.ordered && this.canMove(true));
        this.updateControl((Control)this.down, this.ordered && this.canMove(false));
        this.updateControl((Control)this.create, this.factory != null && this.factory.canCreateObject());
        this.updateControl((Control)this.delete, this.canDelete());
    }

    protected boolean canDelete() {
        return true;
    }

    protected boolean canMove(boolean up) {
        return this.selectedElementsViewer != null && this.selectedElementsViewer.getSelection() != null && !this.selectedElementsViewer.getSelection().isEmpty();
    }

    protected boolean canAdd() {
        boolean canAdd = true;
        if (this.upperBound != -1 && this.allElements.size() >= this.upperBound) {
            canAdd = false;
        }
        return canAdd;
    }

    protected void updateControl(Control control, boolean enabled) {
        if (control != null) {
            control.setEnabled(enabled);
        }
    }

    public void setSelector(IElementSelector selector) {
        if (this.selector != null) {
            this.selector.removeElementSelectionListener(this);
        }
        this.selector = selector;
        this.selector.addElementSelectionListener(this);
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public void setContextElement(Object contextElement) {
        this.contextElement = contextElement;
    }

    public Object getContextElement() {
        return this.contextElement;
    }

    public void doubleClick(DoubleClickEvent event) {
        this.removeAction();
    }

    protected boolean canRemove() {
        return true;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateControls();
    }

    public void dispose() {
        if (this.selector != null) {
            this.selector.removeElementSelectionListener(this);
        }
    }

    protected List<?> getInitialSelection() {
        return this.initialSelection;
    }
}

