/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views.coverage;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;

public class CodeCoverageResult {
    private IModelElement modelElement;
    private CodeCoverageData coverageData;
    private int lines;
    private int covered;
    private int significant;
    private int files;

    public CodeCoverageResult(int lines, int covered, int significant, int files) {
        this.lines = lines;
        this.covered = covered;
        this.significant = significant == -1 ? lines : significant;
        this.files = files;
    }

    public void addCoverageResult(CodeCoverageResult data) {
        this.lines += data.getLines();
        this.covered += data.getCovered();
        this.significant += data.getSignificant();
        this.files += data.getFiles();
    }

    public IModelElement getModelElement() {
        return this.modelElement;
    }

    public CodeCoverageData getCoverageData() {
        return this.coverageData;
    }

    public int getCovered() {
        return this.covered;
    }

    public int getSignificant() {
        return this.significant;
    }

    public int getFiles() {
        return this.files;
    }

    public int getLines() {
        return this.lines;
    }

    public float getPercentage() {
        return (float)this.covered / (float)this.significant;
    }

    public void setModelElement(IModelElement modelElement) {
        this.modelElement = modelElement;
    }

    public void setCoverageData(CodeCoverageData coverageData) {
        this.coverageData = coverageData;
    }
}

