/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.profile.core.engine.ProfileSessionsManager;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.wizards.ProfileSessionsContentProvider;
import org.eclipse.php.profile.ui.wizards.ProfileSessionsLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class HTMLReportWizardFirstPage
extends WizardPage {
    private ProfilerDB fSession;
    private Listener fieldModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = HTMLReportWizardFirstPage.this.validatePage();
            HTMLReportWizardFirstPage.this.setPageComplete(valid);
        }
    };
    private Text fTargetFileField;
    private Button fTargetBtn;
    private String fTargetFile;
    private TableViewer fTableViewer;
    private Button fCommonBtn;
    private Button fExecutionStatisticsBtn;
    private Button fExecutionFlowBtn;
    private boolean fExportCommonInfo;
    private boolean fExportExecutionStatistics;
    private boolean fExportExecutionFlow;

    public HTMLReportWizardFirstPage(ProfilerDB session) {
        super(PHPProfileUIMessages.getString("HTMLReportWizardPage1.0"));
        this.setTitle(PHPProfileUIMessages.getString("HTMLReportWizardPage1.1"));
        this.setDescription(PHPProfileUIMessages.getString("HTMLReportWizardPage1.16"));
        this.fSession = session;
    }

    public ProfilerDB getSession() {
        return this.fSession;
    }

    public String getTargetFile() {
        return this.fTargetFile;
    }

    public boolean isExportCommonInfo() {
        return this.fExportCommonInfo;
    }

    public boolean isExportExecutionStatistics() {
        return this.fExportExecutionStatistics;
    }

    public boolean isExportExecutionFlow() {
        return this.fExportExecutionFlow;
    }

    private void createSelectSessionGroup(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PHPProfileUIMessages.getString("HTMLReportWizardPage1.2"));
        this.fTableViewer = new TableViewer(parent, 2052);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(8);
        this.fTableViewer.getControl().setLayoutData((Object)gridData);
        this.fTableViewer.setContentProvider((IContentProvider)new ProfileSessionsContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ProfileSessionsLabelProvider());
        this.fTableViewer.setInput((Object)ProfileSessionsManager.getSessions());
        if (this.fSession != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.fSession));
        }
    }

    private void createConfigureGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PHPProfileUIMessages.getString("HTMLReportWizardPage1.3"));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        GridData data = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)data);
        this.fCommonBtn = new Button((Composite)group, 32);
        this.fCommonBtn.setText(PHPProfileUIMessages.getString("HTMLReportWizardPage1.4"));
        this.fCommonBtn.setSelection(true);
        this.fCommonBtn.setEnabled(false);
        this.fExecutionStatisticsBtn = new Button((Composite)group, 32);
        this.fExecutionStatisticsBtn.setText(PHPProfileUIMessages.getString("HTMLReportWizardPage1.5"));
        this.fExecutionStatisticsBtn.setSelection(true);
        this.fExecutionFlowBtn = new Button((Composite)group, 32);
        this.fExecutionFlowBtn.setText(PHPProfileUIMessages.getString("HTMLReportWizardPage1.6"));
        this.fExecutionFlowBtn.setSelection(true);
    }

    private void createTargetFileGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PHPProfileUIMessages.getString("HTMLReportWizardPage1.7"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        GridData data = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)data);
        Label label = new Label((Composite)group, 0);
        label.setText(PHPProfileUIMessages.getString("HTMLReportWizardPage1.8"));
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.fTargetFileField = new Text((Composite)group, 2048);
        data = new GridData(768);
        data.horizontalIndent = this.convertWidthInCharsToPixels(2);
        this.fTargetFileField.setLayoutData((Object)data);
        this.fTargetFileField.addListener(24, this.fieldModifyListener);
        this.fTargetBtn = new Button((Composite)group, 0);
        this.fTargetBtn.setText(PHPProfileUIMessages.getString("HTMLReportWizardPage1.9"));
        this.fTargetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedFile;
                FileDialog dialog = new FileDialog(HTMLReportWizardFirstPage.this.getShell(), 8192);
                dialog.setText(PHPProfileUIMessages.getString("HTMLReportWizardPage1.10"));
                dialog.setFilterExtensions(new String[]{"*.html"});
                String dirName = new File(HTMLReportWizardFirstPage.this.fTargetFileField.getText().trim()).getParent();
                if (dirName != null && dirName.length() > 0 && new File(dirName).exists()) {
                    dialog.setFilterPath(new Path(dirName).toOSString());
                }
                if ((selectedFile = dialog.open()) != null) {
                    int dotIndex = selectedFile.lastIndexOf(46);
                    if (dotIndex == -1) {
                        selectedFile = String.valueOf(selectedFile) + ".html";
                    }
                    HTMLReportWizardFirstPage.this.fTargetFileField.setText(selectedFile);
                }
            }
        });
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createSelectSessionGroup(composite);
        this.createConfigureGroup(composite);
        this.createTargetFileGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.exporting_html_report");
    }

    protected boolean validatePage() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element == null) {
            this.setErrorMessage(null);
            this.setMessage(PHPProfileUIMessages.getString("HTMLReportWizardPage1.11"));
            return false;
        }
        this.fSession = (ProfilerDB)element;
        this.fExportCommonInfo = this.fCommonBtn.getSelection();
        this.fExportExecutionStatistics = this.fExecutionStatisticsBtn.getSelection();
        this.fExportExecutionFlow = this.fExecutionFlowBtn.getSelection();
        String targetFile = this.fTargetFileField.getText().trim();
        if (targetFile.length() == 0) {
            this.setErrorMessage(null);
            this.setMessage(PHPProfileUIMessages.getString("HTMLReportWizardPage1.12"));
            return false;
        }
        File file = new File(targetFile);
        if (file.isDirectory()) {
            this.setMessage(null);
            this.setErrorMessage(PHPProfileUIMessages.getString("HTMLReportWizardPage1.13"));
            return false;
        }
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            this.setMessage(null);
            this.setErrorMessage(PHPProfileUIMessages.getString("HTMLReportWizardPage1.14"));
            return false;
        }
        if (!parentFile.isDirectory()) {
            this.setMessage(null);
            this.setErrorMessage(NLS.bind((String)PHPProfileUIMessages.getString("HTMLReportWizardPage1.15"), (Object)file.getParent()));
            return false;
        }
        this.fTargetFile = targetFile;
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

