/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableController;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class NlsFilterComponent
extends Composite {
    private final TableViewer m_tableViewer;
    private final NlsTableController m_controller;
    private final Button m_resetButton;
    private final Map<Language, Text> m_filterFields;

    protected NlsFilterComponent(Composite parent, TableViewer viewer, NlsTableController controller) {
        super(parent, 0x20000000);
        this.m_controller = controller;
        this.setBackground(parent.getBackground());
        this.m_tableViewer = viewer;
        this.m_tableViewer.getTable().addListener(9, event -> this.layout());
        this.m_filterFields = new HashMap<Language, Text>();
        this.m_resetButton = new Button((Composite)this, 0x800008);
        this.m_resetButton.setText("Clear");
        this.m_resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Text t : NlsFilterComponent.this.m_filterFields.values()) {
                    t.setText("");
                }
            }
        });
        this.columnsChanged();
        this.setLayout(new P_FilterComponentLayout());
    }

    public void columnsChanged() {
        HashMap<Language, String> oldContents = new HashMap<Language, String>(this.m_filterFields.size());
        if (!this.m_filterFields.isEmpty()) {
            for (Map.Entry<Language, Text> entry : this.m_filterFields.entrySet()) {
                oldContents.put(entry.getKey(), entry.getValue().getText());
                entry.getValue().dispose();
            }
            this.m_filterFields.clear();
        }
        if (this.m_tableViewer != null && this.m_tableViewer.getTable().getColumnCount() >= 1) {
            TableColumn[] columns = this.m_tableViewer.getTable().getColumns();
            int i = 1;
            while (i < columns.length) {
                Language l = this.m_controller.languageOfColumn(i);
                Text filterField = new Text((Composite)this, 2048);
                String oldText = (String)oldContents.get(l);
                if (oldText != null) {
                    filterField.setText(oldText);
                }
                filterField.addModifyListener(this::handleFilterModified);
                this.m_filterFields.put(l, filterField);
                ++i;
            }
        }
    }

    protected void handleFilterModified(ModifyEvent event) {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        ViewerFilter[] viewerFilterArray = this.m_tableViewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (!(filter instanceof P_ViewerFilter)) {
                filters.add(filter);
            }
            ++n2;
        }
        for (Map.Entry<Language, Text> e : this.m_filterFields.entrySet()) {
            if (e.getValue().getText().isEmpty()) continue;
            filters.add(new P_ViewerFilter(e.getKey(), e.getValue().getText()));
        }
        try {
            this.m_tableViewer.getTable().setRedraw(false);
            this.m_tableViewer.setFilters(filters.toArray(new ViewerFilter[0]));
        }
        finally {
            this.m_tableViewer.getTable().setRedraw(true);
        }
    }

    private final class P_FilterComponentLayout
    extends Layout {
        private P_FilterComponentLayout() {
        }

        protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
            int height = ((NlsFilterComponent)NlsFilterComponent.this).m_resetButton.computeSize((int)-1, (int)hint2).y + 2;
            for (Text t : NlsFilterComponent.this.m_filterFields.values()) {
                height = Math.max(height, t.computeSize((int)-1, (int)hint2).y + 2);
            }
            return new Point(hint, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle parentBounds = composite.getClientArea();
            TableColumn[] columns = NlsFilterComponent.this.m_tableViewer.getTable().getColumns();
            int[] colOrder = NlsFilterComponent.this.m_tableViewer.getTable().getColumnOrder();
            int x = -NlsFilterComponent.this.m_tableViewer.getTable().getHorizontalBar().getSelection();
            int i = 0;
            while (i < columns.length) {
                int colIndex = colOrder[i];
                TableColumn column = columns[colIndex];
                if (i == 1) {
                    NlsFilterComponent.this.m_resetButton.setBounds(1, 1, x - 2, parentBounds.height - 2);
                }
                if (i >= 1) {
                    Language lang = NlsFilterComponent.this.m_controller.languageOfColumn(colIndex);
                    Text text = (Text)NlsFilterComponent.this.m_filterFields.get(lang);
                    if (text != null) {
                        text.setBounds(x + 1, 1, column.getWidth() - 2, parentBounds.height - 2);
                    }
                }
                x += column.getWidth();
                ++i;
            }
            composite.update();
        }
    }

    private static final class P_ViewerFilter
    extends ViewerFilter {
        private final char[] m_pattern;
        private final Language m_lang;

        private P_ViewerFilter(Language lang, String pattern) {
            this.m_lang = lang;
            this.m_pattern = (String.valueOf(pattern.toLowerCase(Locale.ENGLISH)) + '*').toCharArray();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            ITranslationEntry nlsEntry = NlsTableController.entryOfRow(element);
            String text = this.m_lang == null ? nlsEntry.key() : (String)nlsEntry.translation(this.m_lang).orElse(null);
            text = text == null ? "" : Strings.replace((String)text, (String)"&", (String)"");
            return CharOperation.match((char[])this.m_pattern, (char[])text.toCharArray(), (boolean)false);
        }
    }
}

