/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wellform;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.operation.wellform.WellformScoutTypeOperation;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.ui.handlers.HandlerUtil;

public class WellformSelectedHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Set<IResource> resourcesFromSelection = S2eUiUtils.getResourcesOfSelection(selection);
        if (resourcesFromSelection.isEmpty()) {
            WellformSelectedHandler.logNoSelection();
            return null;
        }
        Set<IType> types = WellformSelectedHandler.toTypes(resourcesFromSelection);
        if (types.isEmpty()) {
            WellformSelectedHandler.logNoSelection();
            return null;
        }
        HashSet<IResource> resources = new HashSet<IResource>(types.size());
        for (IType t : types) {
            resources.add(t.getResource());
        }
        MultiRule rule = new MultiRule(resources.toArray(new ISchedulingRule[0]));
        EclipseEnvironment.runInEclipseEnvironment((BiConsumer)new WellformScoutTypeOperation(types, true), (ISchedulingRule)rule);
        return null;
    }

    private static void logNoSelection() {
        SdkLog.warning((String)"Cannot wellform classes in the selected scope because no classes are selected.", (Object[])new Object[0]);
    }

    private static Set<IType> toTypes(Collection<IResource> resources) {
        HashSet<IType> result = new HashSet<IType>(resources.size());
        for (IResource r : resources) {
            IJavaElement element;
            if (r == null || !r.isAccessible() || !JdtUtils.exists((IJavaElement)(element = JavaCore.create((IResource)r)))) continue;
            if (element.getElementType() == 7) {
                result.add((IType)element);
                continue;
            }
            if (element.getElementType() != 5) continue;
            ICompilationUnit icu = (ICompilationUnit)element;
            try {
                Collections.addAll(result, icu.getTypes());
            }
            catch (JavaModelException e) {
                SdkLog.warning((String)"Unable to wellform types in compilation unit {}. Skipping.", (Object[])new Object[]{icu.getElementName(), e});
            }
        }
        return result;
    }
}

