/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.LttngRelaydConnectionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.LttngRelaydConnectionManager;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.LttngRelaydConsumer;
import org.eclipse.tracecompass.internal.lttng2.control.ui.relayd.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.RemoteFetchLogWizard;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportConnectionNodeElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfileElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceGroupElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportTraceWizard;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.ctf.core.CtfConstants;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportHandler
extends BaseControlViewHandler {
    private static final String NOTIFY_IMPORT_STREAMED_PREF_KEY = "NOTIFY_IMPORT_STREAMED";
    protected CommandParameter fParam;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        URI remoteUri;
        CommandParameter param;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            param = this.fParam;
            if (param == null) {
                return null;
            }
            param = param.clone();
        }
        finally {
            this.fLock.unlock();
        }
        IProject project = TmfProjectRegistry.createProject((String)"Remote", null, null);
        if (param.getSession().isLiveTrace()) {
            ImportHandler.importLiveTrace(new LttngRelaydConnectionInfo(param.getSession().getLiveUrl(), param.getSession().getLivePort(), param.getSession().getName()), project);
            return null;
        }
        if (param.getSession().isStreamedTrace()) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            String notify = store.getString(NOTIFY_IMPORT_STREAMED_PREF_KEY);
            if (!"always".equals(notify)) {
                MessageDialogWithToggle.openInformation((Shell)window.getShell(), null, (String)org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportDialogStreamedTraceNotification, (String)org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportDialogStreamedTraceNotificationToggle, (boolean)false, (IPreferenceStore)store, (String)NOTIFY_IMPORT_STREAMED_PREF_KEY);
            }
            TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
            TmfTraceFolder traceFolder = projectElement.getTracesFolder();
            ImportTraceWizard wizard = new ImportTraceWizard();
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)traceFolder));
            WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
            dialog.open();
            return null;
        }
        TraceSessionComponent session = param.getSession();
        RemoteImportProfileElement profile = new RemoteImportProfileElement(null, "LTTng Remote Traces");
        RemoteSystemProxy proxy = session.getTargetNode().getRemoteSystemProxy();
        IRemoteConnection rc = proxy.getRemoteConnection();
        String name = rc.getName();
        if (!rc.hasService(IRemoteConnectionHostService.class)) {
            return null;
        }
        String scheme = rc.getConnectionType().getScheme();
        IRemoteConnectionHostService hostService = (IRemoteConnectionHostService)NonNullUtils.checkNotNull((Object)((IRemoteConnectionHostService)rc.getService(IRemoteConnectionHostService.class)));
        String address = hostService.getHostname();
        String user = hostService.getUsername();
        int port = hostService.getPort();
        try {
            remoteUri = new URI(scheme, user, address, port, null, null, null);
        }
        catch (URISyntaxException e) {
            return false;
        }
        RemoteImportConnectionNodeElement connection = new RemoteImportConnectionNodeElement((TracePackageElement)profile, name, remoteUri.toString());
        String pathString = session.isSnapshotSession() ? session.getSnapshotInfo().getSnapshotPath() : session.getSessionPath();
        Path path = new Path(pathString);
        RemoteImportTraceGroupElement group = new RemoteImportTraceGroupElement((TracePackageElement)connection, path.toString());
        group.setRecursive(true);
        TracePackageTraceElement element = new TracePackageTraceElement((TracePackageElement)group, "", "");
        new TracePackageFilesElement((TracePackageElement)element, ".*");
        String experimentName = path.lastSegment();
        if (!experimentName.startsWith(session.getName())) {
            experimentName = session.getName();
        }
        RemoteFetchLogWizard wizard = new RemoteFetchLogWizard(profile, experimentName);
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        dialog.open();
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        TraceSessionComponent session = null;
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceSessionComponent tmpSession;
                if (!(element instanceof TraceSessionComponent) || !(tmpSession = (TraceSessionComponent)element).isSnapshotSession() && !tmpSession.isLiveTrace() && tmpSession.getSessionState() != TraceSessionState.INACTIVE || tmpSession.isDestroyed()) continue;
                session = tmpSession;
            }
        }
        boolean isEnabled = session != null;
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new CommandParameter((TraceSessionComponent)NonNullUtils.checkNotNull(session));
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    private static void importLiveTrace(final LttngRelaydConnectionInfo connectionInfo, final IProject project) {
        Job job = new Job(org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_ImportJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    LttngRelaydConsumer lttngRelaydConsumer = LttngRelaydConnectionManager.getInstance().getConsumer(connectionInfo);
                    try {
                        lttngRelaydConsumer.connect();
                    }
                    catch (CoreException e) {
                        return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.LttngRelaydConnectionManager_ConnectionError, (Throwable)e);
                    }
                    ImportHandler.initializeTraceResource(connectionInfo, lttngRelaydConsumer.getTracePath(), project);
                    return Status.OK_STATUS;
                }
                catch (CoreException | TmfTraceImportException e) {
                    return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_LiveTraceInitError, e);
                }
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private static void initializeTraceResource(LttngRelaydConnectionInfo connectionInfo, String tracePath, IProject project) throws CoreException, TmfTraceImportException {
        TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        TmfTraceFolder tracesFolder = projectElement.getTracesFolder();
        if (tracesFolder != null) {
            IFolder folder = tracesFolder.getResource();
            IFolder traceFolder = folder.getFolder(connectionInfo.getSessionName());
            Path location = new Path(tracePath);
            IStatus result = ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)folder, (IPath)location);
            if (!result.isOK()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", result.getMessage()));
            }
            traceFolder.createLink((IPath)location, 256, (IProgressMonitor)new NullProgressMonitor());
            TraceTypeHelper selectedTraceType = TmfTraceTypeUIUtils.selectTraceType((String)location.toOSString(), null, null);
            TmfTraceTypeUIUtils.setTraceType((IResource)traceFolder, (TraceTypeHelper)selectedTraceType);
            TmfTraceElement found = null;
            List traces = tracesFolder.getTraces();
            for (TmfTraceElement candidate : traces) {
                if (!candidate.getName().equals(connectionInfo.getSessionName())) continue;
                found = candidate;
            }
            if (found == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages.TraceControl_LiveTraceElementError));
            }
            traceFolder.setPersistentProperty(CtfConstants.LIVE_HOST, connectionInfo.getHost());
            traceFolder.setPersistentProperty(CtfConstants.LIVE_PORT, Integer.toString(connectionInfo.getPort()));
            traceFolder.setPersistentProperty(CtfConstants.LIVE_SESSION_NAME, connectionInfo.getSessionName());
            TmfTraceElement finalTrace = found;
            Display.getDefault().syncExec(() -> TmfOpenTraceHelper.openTraceFromElement((TmfCommonProjectElement)finalTrace));
        }
    }
}

