/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.accessor;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.AccessorUtils;
import org.eclipse.wb.internal.core.model.property.accessor.AssignmentsSequence;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IAccessibleExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IExposableExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldAccessor
extends ExpressionAccessor {
    private final Field m_field;
    private final String m_fieldName;
    private final IAccessibleExpressionAccessor m_accessibleAccessor;
    private final PropertyTooltipProvider m_tooltipProvider;
    private final IExposableExpressionAccessor m_exposableAccessor = new IExposableExpressionAccessor(){

        @Override
        public Class<?> getValueClass(JavaInfo javaInfo) {
            return FieldAccessor.this.m_field.getType();
        }

        @Override
        public String getGetterCode(JavaInfo javaInfo) throws Exception {
            return FieldAccessor.this.m_fieldName;
        }

        @Override
        public String getSetterCode(JavaInfo javaInfo, String source) throws Exception {
            return String.valueOf(FieldAccessor.this.m_fieldName) + " = " + source;
        }
    };

    public FieldAccessor(Field field) {
        Assert.isNotNull((Object)field);
        this.m_field = field;
        this.m_fieldName = this.m_field.getName();
        this.m_accessibleAccessor = AccessorUtils.IAccessibleExpressionAccessor_forField(this.m_field);
        this.m_tooltipProvider = AccessorUtils.PropertyTooltipProvider_forField(this.m_field);
    }

    @Override
    public void visit(JavaInfo javaInfo, int state) throws Exception {
        super.visit(javaInfo, state);
        if (this.isTimeToGetDefaultValue(javaInfo, state)) {
            Object defaultValue = this.getFieldValue(javaInfo);
            javaInfo.putArbitraryValue(this, defaultValue);
        }
    }

    private boolean isTimeToGetDefaultValue(JavaInfo javaInfo, int state) {
        return state == 1;
    }

    private Object getFieldValue(final JavaInfo javaInfo) {
        return ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<Object>(){

            public Object runObject() throws Exception {
                Object object = javaInfo.getObject();
                return ReflectionUtils.getFieldObject((Object)object, (String)FieldAccessor.this.m_fieldName);
            }
        }, (Object)Property.UNKNOWN_VALUE);
    }

    @Override
    public Expression getExpression(JavaInfo javaInfo) throws Exception {
        Assignment assignment = this.getFieldAssignment(javaInfo);
        return FieldAccessor.getExpression(assignment);
    }

    @Override
    public boolean setExpression(final JavaInfo javaInfo, final String source) throws Exception {
        boolean hasAssignment;
        boolean bl = hasAssignment = !javaInfo.getFieldAssignments(this.m_fieldName).isEmpty();
        if (source == null) {
            if (hasAssignment) {
                ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        javaInfo.removeFieldAssignments(FieldAccessor.this.m_fieldName);
                    }
                });
            }
        } else if (hasAssignment) {
            Assignment assignment = this.getFieldAssignmentForUpdate(javaInfo);
            final Expression oldExpression = FieldAccessor.getExpression(assignment);
            if (!javaInfo.getEditor().getSource((ASTNode)oldExpression).equals(source)) {
                ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        javaInfo.getEditor().replaceExpression(oldExpression, source);
                    }
                });
            }
        } else {
            ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    javaInfo.addFieldAssignment(FieldAccessor.this.m_fieldName, source);
                }
            });
        }
        return true;
    }

    @Override
    public Object getDefaultValue(JavaInfo javaInfo) throws Exception {
        return javaInfo.getArbitraryValue(this);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IAccessibleExpressionAccessor.class) {
            return adapter.cast(this.m_accessibleAccessor);
        }
        if (adapter == IExposableExpressionAccessor.class) {
            return adapter.cast(this.m_exposableAccessor);
        }
        if (adapter == PropertyTooltipProvider.class) {
            return adapter.cast(this.m_tooltipProvider);
        }
        return super.getAdapter(adapter);
    }

    private Assignment getFieldAssignment(JavaInfo javaInfo) throws Exception {
        return javaInfo.getFieldAssignment(this.m_fieldName);
    }

    private static Expression getExpression(Assignment assignment) {
        return assignment == null ? null : assignment.getRightHandSide();
    }

    private Assignment getFieldAssignmentForUpdate(JavaInfo javaInfo) throws Exception {
        Assignment targetAssignment = this.getFieldAssignment(javaInfo);
        if (targetAssignment != null) {
            AssignmentsSequence sequence = FieldAccessor.getAssignmentsSequence(targetAssignment);
            if (sequence.getAssignments().size() == 1) {
                return targetAssignment;
            }
            return FieldAccessor.splitAssignmentsSequence(javaInfo, targetAssignment, sequence);
        }
        return null;
    }

    private static AssignmentsSequence getAssignmentsSequence(Assignment targetAssignment) {
        ArrayList assignments = Lists.newArrayList();
        Assignment leftAssignment = targetAssignment;
        while (leftAssignment.getParent() instanceof Assignment) {
            leftAssignment = (Assignment)leftAssignment.getParent();
            assignments.add(leftAssignment);
        }
        Assert.isTrue((boolean)(leftAssignment.getParent() instanceof ExpressionStatement), (String)"Assignments are expected to be directly in ExpressionStatement, but %s found.", (Object[])new Object[]{leftAssignment.getParent()});
        assignments.add(targetAssignment);
        Assignment rightAssignment = targetAssignment;
        while (rightAssignment.getRightHandSide() instanceof Assignment) {
            rightAssignment = (Assignment)rightAssignment.getRightHandSide();
            assignments.add(rightAssignment);
        }
        Expression assignedExpression = rightAssignment.getRightHandSide();
        return new AssignmentsSequence(assignments, assignedExpression);
    }

    private static Assignment splitAssignmentsSequence(JavaInfo javaInfo, Assignment targetAssignment, AssignmentsSequence sequence) throws Exception {
        Assignment newTargetAssignment = null;
        AstEditor editor = javaInfo.getEditor();
        String assignedSource = editor.getSource((ASTNode)sequence.getAssignedExpression());
        Statement targetStatement = AstNodeUtils.getEnclosingStatement((ASTNode)targetAssignment);
        for (Assignment assignment : sequence.getAssignments()) {
            String source = String.valueOf(editor.getSource((ASTNode)assignment.getLeftHandSide())) + " = " + assignedSource;
            StatementTarget target = new StatementTarget(targetStatement, false);
            Assignment newAssignment = (Assignment)javaInfo.addExpressionStatement(target, source);
            if (assignment == targetAssignment) {
                newTargetAssignment = newAssignment;
            }
            targetStatement = AstNodeUtils.getEnclosingStatement((ASTNode)newAssignment);
        }
        editor.removeEnclosingStatement((ASTNode)targetAssignment);
        Assert.isNotNull(newTargetAssignment);
        return newTargetAssignment;
    }
}

