/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.gef;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.policy.layout.LayoutPolicyUtils2;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.swing.FormLayout.gef.FormGridHelper;
import org.eclipse.wb.internal.swing.FormLayout.gef.FormSelectionEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.gef.GefMessages;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.edit.ColumnHeaderEditPart;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.edit.RowHeaderEditPart;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.layout.ColumnsLayoutEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.layout.RowsLayoutEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.model.FormColumnInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormRowInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.ColumnsDialog;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.RowsDialog;
import org.eclipse.wb.internal.swing.gef.ComponentsLayoutRequestValidator;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;

public final class FormLayoutEditPolicy
extends AbstractGridLayoutEditPolicy {
    private final FormLayoutInfo m_layout;

    public FormLayoutEditPolicy(FormLayoutInfo layout) {
        super((ObjectInfo)layout);
        this.m_layout = layout;
        this.m_gridTargetHelper = new FormGridHelper((GraphicalEditPolicy)this, true);
        this.m_gridSelectionHelper = new FormGridHelper((GraphicalEditPolicy)this, false);
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return ComponentsLayoutRequestValidator.INSTANCE_EXT;
    }

    protected IGridInfo getGridInfo() {
        return this.m_layout.getGridInfo();
    }

    protected void decorateChild(EditPart child) {
        if (child.getModel() instanceof ComponentInfo) {
            ComponentInfo component = (ComponentInfo)child.getModel();
            FormSelectionEditPolicy selectionPolicy = new FormSelectionEditPolicy(this.m_layout, component);
            child.installEditPolicy((Object)"Selection Feedback", (EditPolicy)selectionPolicy);
        }
    }

    private boolean isValidTarget() {
        if (!this.m_target.m_valid) {
            return false;
        }
        if (!this.m_layout.canChangeDimensions()) {
            if (this.m_target.m_columnInsert || this.m_target.m_rowInsert) {
                return false;
            }
            if (this.m_target.m_column >= this.m_layout.getColumns().size() || this.m_target.m_row >= this.m_layout.getRows().size()) {
                return false;
            }
        }
        return true;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object newObject;
        if (this.isValidTarget() && (newObject = request.getNewObject()) instanceof ComponentInfo) {
            final ComponentInfo component = (ComponentInfo)newObject;
            return new EditCommand((ObjectInfo)this.m_layout){

                protected void executeEdit() throws Exception {
                    FormLayoutEditPolicy.this.m_layout.command_CREATE(component, 1 + ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_column, ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_columnInsert, 1 + ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_row, ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_rowInsert);
                }
            };
        }
        return null;
    }

    protected Command getPasteCommand(PasteRequest request) {
        List mementos = (List)request.getMemento();
        if (this.isValidTarget() && mementos.size() == 1) {
            return LayoutPolicyUtils2.getPasteCommand((JavaInfo)this.m_layout, (PasteRequest)request, ComponentInfo.class, (LayoutPolicyUtils2.IPasteProcessor)new LayoutPolicyUtils2.IPasteProcessor<ComponentInfo>(){

                public void process(ComponentInfo component) throws Exception {
                    FormLayoutEditPolicy.this.m_layout.command_CREATE(component, 1 + ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_column, ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_columnInsert, 1 + ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_row, ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_rowInsert);
                }
            });
        }
        return null;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        EditPart moveEditPart;
        if (this.isValidTarget() && request.getEditParts().size() == 1 && (moveEditPart = (EditPart)request.getEditParts().get(0)).getModel() instanceof ComponentInfo) {
            final ComponentInfo component = (ComponentInfo)moveEditPart.getModel();
            return new EditCommand((ObjectInfo)this.m_layout){

                protected void executeEdit() throws Exception {
                    FormLayoutEditPolicy.this.m_layout.command_MOVE(component, 1 + ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_column, ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_columnInsert, 1 + ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_row, ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_rowInsert);
                }
            };
        }
        return null;
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        EditPart moveEditPart;
        if (this.isValidTarget() && request.getEditParts().size() == 1 && (moveEditPart = (EditPart)request.getEditParts().get(0)).getModel() instanceof ComponentInfo) {
            final ComponentInfo component = (ComponentInfo)moveEditPart.getModel();
            return new EditCommand((ObjectInfo)this.m_layout){

                protected void executeEdit() throws Exception {
                    FormLayoutEditPolicy.this.m_layout.command_ADD(component, 1 + ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_column, ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_columnInsert, 1 + ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_row, ((FormLayoutEditPolicy)FormLayoutEditPolicy.this).m_target.m_rowInsert);
                }
            };
        }
        return null;
    }

    protected void updateGridTarget(Point mouseLocation) throws Exception {
        boolean nextGap;
        boolean prevGap;
        boolean isLast;
        Interval interval;
        this.m_target = new AbstractGridLayoutEditPolicy.GridTarget();
        mouseLocation = mouseLocation.getCopy();
        FigureUtils.translateAbsoluteToFigure2((Figure)this.getHostFigure(), (Translatable)mouseLocation);
        IGridInfo gridInfo = this.m_layout.getGridInfo();
        Interval[] columnIntervals = gridInfo.getColumnIntervals();
        Interval[] rowIntervals = gridInfo.getRowIntervals();
        int lastX = columnIntervals.length != 0 ? columnIntervals[columnIntervals.length - 1].end() : gridInfo.getInsets().left;
        int lastY = rowIntervals.length != 0 ? rowIntervals[rowIntervals.length - 1].end() : gridInfo.getInsets().top;
        int insertDelta = 3;
        if (rowIntervals.length != 0) {
            this.m_target.m_columnInsertBounds.y = rowIntervals[0].begin - 5;
            this.m_target.m_columnInsertBounds.setBottom(lastY + 5);
        }
        if (columnIntervals.length != 0) {
            this.m_target.m_rowInsertBounds.x = columnIntervals[0].begin - 5;
            this.m_target.m_rowInsertBounds.setRight(lastX + 5);
        }
        int columnIndex = 0;
        while (columnIndex < columnIntervals.length) {
            interval = columnIntervals[columnIndex];
            if (interval.contains(mouseLocation.x)) {
                List<FormColumnInfo> columns = this.m_layout.getColumns();
                FormColumnInfo column = columns.get(columnIndex);
                isLast = columnIndex == columnIntervals.length - 1;
                FormColumnInfo prevColumn = columnIndex != 0 ? columns.get(columnIndex - 1) : null;
                prevGap = prevColumn != null && prevColumn.isGap();
                FormColumnInfo nextColumn = columnIndex < columns.size() - 1 ? columns.get(columnIndex + 1) : null;
                nextGap = nextColumn != null && nextColumn.isGap();
                this.m_target.m_column = columnIndex;
                if (column.isGap()) {
                    this.m_target.m_columnInsert = true;
                    this.m_target.m_feedbackBounds.width = 3 * interval.length;
                    this.m_target.m_feedbackBounds.x = interval.center() - this.m_target.m_feedbackBounds.width / 2;
                    this.m_target.m_columnInsertBounds.x = interval.begin;
                    this.m_target.m_columnInsertBounds.width = interval.length + 1;
                } else if (mouseLocation.x - interval.begin <= insertDelta && !prevGap) {
                    this.m_target.m_columnInsert = true;
                    this.m_target.m_feedbackBounds.width = 21;
                    this.m_target.m_feedbackBounds.x = interval.begin - this.m_target.m_feedbackBounds.width / 2;
                    this.m_target.m_columnInsertBounds.x = interval.begin - 3;
                    this.m_target.m_columnInsertBounds.width = 7;
                } else if (!isLast && interval.end() - mouseLocation.x <= insertDelta && !nextGap) {
                    ++this.m_target.m_column;
                    this.m_target.m_columnInsert = true;
                    this.m_target.m_feedbackBounds.width = 21;
                    this.m_target.m_feedbackBounds.x = interval.end() - this.m_target.m_feedbackBounds.width / 2;
                    this.m_target.m_columnInsertBounds.x = interval.end() - 3;
                    this.m_target.m_columnInsertBounds.width = 7;
                } else {
                    this.m_target.m_feedbackBounds.x = interval.begin;
                    this.m_target.m_feedbackBounds.width = interval.length + 1;
                }
            }
            ++columnIndex;
        }
        if (this.m_target.m_column == -1) {
            int columnGap = gridInfo.getVirtualColumnGap();
            int newWidth = gridInfo.getVirtualColumnSize() + columnGap;
            int newDelta = 1 + Math.max(mouseLocation.x - lastX - columnGap / 2, 0) / newWidth;
            this.m_target.m_column = columnIntervals.length + 2 * newDelta - 1;
            this.m_target.m_feedbackBounds.x = lastX + newWidth * (newDelta - 1) + columnGap;
            this.m_target.m_feedbackBounds.width = gridInfo.getVirtualColumnSize() + 1;
        }
        int rowIndex = 0;
        while (rowIndex < rowIntervals.length) {
            interval = rowIntervals[rowIndex];
            if (interval.contains(mouseLocation.y)) {
                List<FormRowInfo> rows = this.m_layout.getRows();
                FormRowInfo row = rows.get(rowIndex);
                isLast = rowIndex == rowIntervals.length - 1;
                FormRowInfo prevRow = rowIndex != 0 ? rows.get(rowIndex - 1) : null;
                prevGap = prevRow != null && prevRow.isGap();
                FormRowInfo nextRow = rowIndex < rows.size() - 1 ? rows.get(rowIndex + 1) : null;
                nextGap = nextRow != null && nextRow.isGap();
                this.m_target.m_row = rowIndex;
                if (row.isGap()) {
                    this.m_target.m_rowInsert = true;
                    this.m_target.m_feedbackBounds.height = 3 * interval.length;
                    this.m_target.m_feedbackBounds.y = interval.center() - this.m_target.m_feedbackBounds.height / 2;
                    this.m_target.m_rowInsertBounds.y = interval.begin;
                    this.m_target.m_rowInsertBounds.height = interval.length + 1;
                } else if (mouseLocation.y - interval.begin <= insertDelta && !prevGap) {
                    this.m_target.m_rowInsert = true;
                    this.m_target.m_feedbackBounds.height = 15;
                    this.m_target.m_feedbackBounds.y = interval.begin - this.m_target.m_feedbackBounds.height / 2;
                    this.m_target.m_rowInsertBounds.y = interval.begin - 2;
                    this.m_target.m_rowInsertBounds.height = 5;
                } else if (!isLast && interval.end() - mouseLocation.y <= insertDelta && !nextGap) {
                    ++this.m_target.m_row;
                    this.m_target.m_rowInsert = true;
                    this.m_target.m_feedbackBounds.height = 15;
                    this.m_target.m_feedbackBounds.y = interval.end() - this.m_target.m_feedbackBounds.height / 2;
                    this.m_target.m_rowInsertBounds.y = interval.end() - 2;
                    this.m_target.m_rowInsertBounds.height = 5;
                } else {
                    this.m_target.m_feedbackBounds.y = interval.begin;
                    this.m_target.m_feedbackBounds.height = interval.length + 1;
                }
            }
            ++rowIndex;
        }
        if (this.m_target.m_row == -1) {
            int rowGap = gridInfo.getVirtualRowGap();
            int newHeight = gridInfo.getVirtualRowSize() + rowGap;
            int newDelta = 1 + Math.max(mouseLocation.y - lastY - rowGap / 2, 0) / newHeight;
            this.m_target.m_row = rowIntervals.length + 2 * newDelta - 1;
            this.m_target.m_feedbackBounds.y = lastY + newHeight * (newDelta - 1) + rowGap;
            this.m_target.m_feedbackBounds.height = gridInfo.getVirtualRowSize() + 1;
        }
    }

    public LayoutEditPolicy getContainerLayoutPolicy(boolean horizontal) {
        if (horizontal) {
            return new ColumnsLayoutEditPolicy(this, this.m_layout);
        }
        return new RowsLayoutEditPolicy(this, this.m_layout);
    }

    public List<?> getHeaders(boolean horizontal) {
        return horizontal ? this.m_layout.getColumns() : this.m_layout.getRows();
    }

    public EditPart createHeaderEditPart(boolean horizontal, Object model) {
        if (horizontal) {
            return new ColumnHeaderEditPart(this.m_layout, (FormColumnInfo)model, this.getHostFigure());
        }
        return new RowHeaderEditPart(this.m_layout, (FormRowInfo)model, this.getHostFigure());
    }

    public void buildContextMenu(IMenuManager manager, boolean horizontal) {
        if (horizontal) {
            manager.add((IAction)new ObjectInfoAction((ObjectInfo)this.m_layout, GefMessages.FormLayoutEditPolicy_appendColumnAction){

                protected void runEx() throws Exception {
                    FormLayoutEditPolicy.this.m_layout.insertColumn(FormLayoutEditPolicy.this.m_layout.getColumns().size());
                }
            });
        } else {
            manager.add((IAction)new ObjectInfoAction((ObjectInfo)this.m_layout, GefMessages.FormLayoutEditPolicy_appendRowAction){

                protected void runEx() throws Exception {
                    FormLayoutEditPolicy.this.m_layout.insertRow(FormLayoutEditPolicy.this.m_layout.getRows().size());
                }
            });
        }
    }

    public void handleDoubleClick(boolean horizontal) {
        if (horizontal) {
            new ColumnsDialog(DesignerPlugin.getShell(), this.m_layout).open();
        } else {
            new RowsDialog(DesignerPlugin.getShell(), this.m_layout).open();
        }
    }
}

