/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.internal.AbstractRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Runtime
extends AbstractRuntime {
    private final List<IRuntimeComponent> components = new ArrayList<IRuntimeComponent>();
    private final List<IRuntimeComponent> componentsReadOnly = Collections.unmodifiableList(this.components);
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, String> propertiesReadOnly = Collections.unmodifiableMap(this.properties);
    private Set<IProjectFacetVersion> supported = null;

    Runtime() {
    }

    @Override
    public List<IRuntimeComponent> getRuntimeComponents() {
        return this.componentsReadOnly;
    }

    void addRuntimeComponent(IRuntimeComponent component) {
        ((RuntimeComponent)component).setRuntime(this);
        this.components.add(component);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.propertiesReadOnly;
    }

    void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public synchronized boolean supports(IProjectFacetVersion fv) {
        if (fv.getPluginId() == null) {
            return true;
        }
        if (this.supported == null) {
            this.supported = RuntimeManagerImpl.getSupportedFacets(this.components);
        }
        return this.supported.contains(fv);
    }
}

