/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.Event;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventSet;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.ExceptionEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ExceptionRequest;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptThread;

public class JavaScriptExceptionBreakpoint
extends JavaScriptBreakpoint {
    public static final String MESSAGE = "org.eclipse.wst.jsdt.debug.core.exception_message";
    private ExceptionRequest request = null;

    public JavaScriptExceptionBreakpoint() {
    }

    public JavaScriptExceptionBreakpoint(final Map attributes) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker("org.eclipse.wst.jsdt.debug.core.scriptload.breakpoint.marker");
                JavaScriptExceptionBreakpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.id", JavaScriptExceptionBreakpoint.this.getModelIdentifier());
                attributes.put("org.eclipse.debug.core.enabled", true);
                Integer nochar = -1;
                attributes.put("charStart", nochar);
                attributes.put("charEnd", nochar);
                JavaScriptExceptionBreakpoint.this.ensureMarker().setAttributes(attributes);
                JavaScriptExceptionBreakpoint.this.register(false);
            }
        };
        this.run(this.getMarkerRule((IResource)ResourcesPlugin.getWorkspace().getRoot()), wr);
    }

    @Override
    public String getModelIdentifier() {
        return "org.eclipse.wst.jsdt.debug.model";
    }

    @Override
    public void addToTarget(JavaScriptDebugTarget target) throws CoreException {
        if (target.isTerminated() || this.shouldSkipBreakpoint()) {
            return;
        }
        if (this.request == null) {
            this.request = target.getVM().eventRequestManager().createExceptionRequest();
            this.request.setEnabled(true);
            this.addRequestForTarget(target, this.request);
        }
    }

    @Override
    protected void deregisterRequest(JavaScriptDebugTarget target, EventRequest request) {
        target.removeJSDIEventListener(this, request);
        this.request = null;
    }

    @Override
    protected boolean createRequest(JavaScriptDebugTarget target, ScriptReference script) throws CoreException {
        return true;
    }

    @Override
    public boolean handleEvent(Event event, JavaScriptDebugTarget target, boolean suspendVote, EventSet eventSet) {
        if (event instanceof ExceptionEvent) {
            try {
                ExceptionEvent eevent = (ExceptionEvent)event;
                this.setAttribute(MESSAGE, eevent.message());
                JavaScriptThread thread = target.findThread(eevent.thread());
                if (thread != null) {
                    thread.addBreakpoint(this);
                    return false;
                }
            }
            catch (CoreException ce) {
                JavaScriptDebugPlugin.log(ce);
            }
        }
        return true;
    }

    @Override
    public void eventSetComplete(Event event, JavaScriptDebugTarget target, boolean suspend, EventSet eventSet) {
        JavaScriptThread thread;
        if (event instanceof ExceptionEvent && (thread = target.findThread(((ExceptionEvent)event).thread())) != null) {
            thread.suspendForException(this);
        }
    }
}

