/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.docker.launcher;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager2;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.docker.launcher.DockerLaunchUIPlugin;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.cdt.internal.docker.launcher.ui.launchbar.ContainerGCCToolChain;
import org.eclipse.cdt.internal.docker.launcher.ui.launchbar.ContainerGCCToolChainProvider;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTargetManager2;
import org.eclipse.launchbar.core.target.ILaunchTargetProvider;
import org.eclipse.launchbar.core.target.ILaunchTargetWorkingCopy;
import org.eclipse.launchbar.core.target.TargetStatus;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionState;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerImage;

public class ContainerTargetTypeProvider
implements ILaunchTargetProvider,
IDockerConnectionManagerListener {
    public static final String TYPE_ID = "org.eclipse.cdt.docker.launcher.launchTargetType.container";
    public static final String CONTAINER_LINUX = "linux-container";
    private static final JobGroup containerTargetTypeGroup = new JobGroup(Messages.ContainerTargetTypeProviderJobGroup_name, 1, 1);
    private ILaunchTargetManager targetManager;

    public synchronized void init(ILaunchTargetManager targetManager) {
        ILaunchTarget[] targets;
        this.targetManager = targetManager;
        ILaunchBarManager launchbarManager = (ILaunchBarManager)CDebugCorePlugin.getService(ILaunchBarManager.class);
        ILaunchTarget defaultTarget = null;
        try {
            defaultTarget = launchbarManager.getActiveLaunchTarget();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        IDockerConnection[] connections = DockerConnectionManager.getInstance().getConnections();
        HashMap<String, IDockerConnection> establishedConnectionMap = new HashMap<String, IDockerConnection>();
        HashSet<String> imageNames = new HashSet<String>();
        IDockerConnection[] iDockerConnectionArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IDockerConnection connection = iDockerConnectionArray[n2];
            List images = connection.getImages();
            if (connection.getState() == EnumDockerConnectionState.ESTABLISHED) {
                establishedConnectionMap.put(connection.getUri(), connection);
            }
            for (IDockerImage image : images) {
                if (image.isDangling() || image.isIntermediateImage()) continue;
                String imageName = "[" + ((String)image.repoTags().get(0)).replace(':', '_') + "]";
                if (imageNames.contains(imageName)) {
                    imageName = String.valueOf(imageName) + "[" + connection.getName() + "]";
                }
                imageNames.add(imageName);
                ILaunchTarget target = targetManager.getLaunchTarget(TYPE_ID, imageName);
                if (target == null) {
                    target = targetManager.addLaunchTarget(TYPE_ID, imageName);
                }
                ILaunchTargetWorkingCopy wc = target.getWorkingCopy();
                wc.setAttribute("os", CONTAINER_LINUX);
                wc.setAttribute("arch", Platform.getOSArch());
                wc.setAttribute("connection_uri", connection.getUri());
                wc.setAttribute("image_id", (String)image.repoTags().get(0));
                wc.save();
            }
            ++n2;
        }
        ILaunchTarget[] iLaunchTargetArray = targets = targetManager.getLaunchTargetsOfType(TYPE_ID);
        int n3 = targets.length;
        n = 0;
        while (n < n3) {
            ILaunchTarget target = iLaunchTargetArray[n];
            try {
                String uri = target.getAttribute("connection_uri", "");
                if (!establishedConnectionMap.containsKey(uri)) {
                    targetManager.removeLaunchTarget(target);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            ++n;
        }
        DockerConnectionManager.getInstance().addConnectionManagerListener((IDockerConnectionManagerListener)this);
        Job checkConfigs = new Job("Check configs"){

            protected IStatus run(IProgressMonitor monitor) {
                ICBuildConfigurationManager mgr = (ICBuildConfigurationManager)CCorePlugin.getService(ICBuildConfigurationManager.class);
                ICBuildConfigurationManager2 cbuildmanager = (ICBuildConfigurationManager2)mgr;
                cbuildmanager.recheckConfigs();
                return Status.OK_STATUS;
            }
        };
        checkConfigs.setJobGroup(containerTargetTypeGroup);
        checkConfigs.setUser(true);
        checkConfigs.schedule();
        try {
            if (defaultTarget != null) {
                launchbarManager.setActiveLaunchTarget(defaultTarget);
            }
        }
        catch (CoreException e) {
            DockerLaunchUIPlugin.log(e);
        }
    }

    public TargetStatus getStatus(ILaunchTarget target) {
        while (containerTargetTypeGroup.getState() != 0) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return TargetStatus.OK_STATUS;
    }

    public synchronized void changeEvent(final IDockerConnection connection, final int type) {
        Job checkConfigs = new Job("Check configs"){

            protected IStatus run(IProgressMonitor monitor) {
                ICBuildConfigurationManager mgr = (ICBuildConfigurationManager)CCorePlugin.getService(ICBuildConfigurationManager.class);
                ICBuildConfigurationManager2 manager = (ICBuildConfigurationManager2)mgr;
                if (type == 0 || type == 4) {
                    ILaunchBarManager launchbarManager = (ILaunchBarManager)CDebugCorePlugin.getService(ILaunchBarManager.class);
                    ILaunchTarget defaultTarget = null;
                    try {
                        defaultTarget = launchbarManager.getActiveLaunchTarget();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    List images = connection.getImages();
                    ContainerGCCToolChainProvider provider = new ContainerGCCToolChainProvider();
                    for (IDockerImage image : images) {
                        if (image.isDangling() || image.isIntermediateImage()) continue;
                        String imageName = "[" + ((String)image.repoTags().get(0)).replace(':', '_') + "]";
                        String imageName2 = String.valueOf(imageName) + "[" + connection.getName() + "]";
                        ILaunchTarget target = ContainerTargetTypeProvider.this.targetManager.getLaunchTarget(ContainerTargetTypeProvider.TYPE_ID, imageName2);
                        if (target != null) continue;
                        target = ContainerTargetTypeProvider.this.targetManager.getLaunchTarget(ContainerTargetTypeProvider.TYPE_ID, imageName);
                        if (target != null) {
                            if (target.getAttribute("connection_uri", "").equals(connection.getUri())) continue;
                            imageName = imageName2;
                        }
                        target = ((ILaunchTargetManager2)ContainerTargetTypeProvider.this.targetManager).addLaunchTargetNoNotify(ContainerTargetTypeProvider.TYPE_ID, imageName);
                        ILaunchTargetWorkingCopy wc = target.getWorkingCopy();
                        wc.setAttribute("os", ContainerTargetTypeProvider.CONTAINER_LINUX);
                        wc.setAttribute("arch", Platform.getOSArch());
                        wc.setAttribute("connection_uri", connection.getUri());
                        wc.setAttribute("image_id", (String)image.repoTags().get(0));
                        wc.save();
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("os", ContainerTargetTypeProvider.CONTAINER_LINUX);
                        properties.put("arch", Platform.getOSArch());
                        properties.put("connection_uri", connection.getUri());
                        properties.put("image_id", (String)image.repoTags().get(0));
                        properties.put("linux-container-id", ((String)image.repoTags().get(0)).replace(':', '_'));
                        IToolChainManager toolChainManager = (IToolChainManager)MakeCorePlugin.getService(IToolChainManager.class);
                        try {
                            Collection toolChains = toolChainManager.getToolChainsMatching(properties);
                            if (!toolChains.isEmpty()) continue;
                            ContainerGCCToolChain toolChain = new ContainerGCCToolChain("gcc-img-" + image.id().substring(0, 19), provider, properties, null);
                            toolChainManager.addToolChain((IToolChain)toolChain);
                        }
                        catch (CoreException e) {
                            DockerLaunchUIPlugin.log(e);
                        }
                    }
                    if (defaultTarget != null) {
                        try {
                            launchbarManager.setActiveLaunchTarget(defaultTarget);
                        }
                        catch (CoreException e) {
                            DockerLaunchUIPlugin.log(e);
                        }
                    }
                    manager.recheckConfigs();
                } else if (type == 1 || type == 5) {
                    ILaunchTarget[] targets;
                    String connectionURI = connection.getUri();
                    ILaunchTarget[] iLaunchTargetArray = targets = ContainerTargetTypeProvider.this.targetManager.getLaunchTargetsOfType(ContainerTargetTypeProvider.TYPE_ID);
                    int n = targets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchTarget target = iLaunchTargetArray[n2];
                        String uri = target.getAttribute("connection_uri", "");
                        if (connectionURI.equals(uri)) {
                            ContainerTargetTypeProvider.this.targetManager.removeLaunchTarget(target);
                        }
                        ++n2;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        checkConfigs.setUser(true);
        checkConfigs.setJobGroup(containerTargetTypeGroup);
        checkConfigs.schedule();
    }
}

