/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api;

import java.util.Collection;
import java.util.IntSummaryStatistics;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToCharFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToShortFunction;
import org.eclipse.collections.api.block.function.primitive.LongByteToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;

public interface ByteIterable
extends PrimitiveIterable {
    public ByteIterator byteIterator();

    public byte[] toArray();

    public boolean contains(byte var1);

    public boolean containsAll(byte ... var1);

    public boolean containsAll(ByteIterable var1);

    public void forEach(ByteProcedure var1);

    public void each(ByteProcedure var1);

    default public ByteIterable tap(ByteProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public ByteIterable select(BytePredicate var1);

    public ByteIterable reject(BytePredicate var1);

    default public <R extends MutableByteCollection> R select(BytePredicate predicate, R target) {
        this.each(each -> {
            if (predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    default public <R extends MutableByteCollection> R reject(BytePredicate predicate, R target) {
        this.each(each -> {
            if (!predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    public <V> RichIterable<V> collect(ByteToObjectFunction<? extends V> var1);

    default public <V, R extends Collection<V>> R collect(ByteToObjectFunction<? extends V> function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <V, R extends Collection<V>> R flatCollect(ByteToObjectFunction<? extends Iterable<V>> function, R target) {
        this.each(each -> {
            Iterable iterable = (Iterable)function.valueOf(each);
            if (iterable instanceof Collection) {
                target.addAll((Collection)iterable);
            } else {
                iterable.forEach(target::add);
            }
        });
        return target;
    }

    default public <R extends MutableBooleanCollection> R collectBoolean(ByteToBooleanFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableByteCollection> R collectByte(ByteToByteFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableCharCollection> R collectChar(ByteToCharFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableShortCollection> R collectShort(ByteToShortFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableIntCollection> R collectInt(ByteToIntFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableFloatCollection> R collectFloat(ByteToFloatFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableLongCollection> R collectLong(ByteToLongFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableDoubleCollection> R collectDouble(ByteToDoubleFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    public byte detectIfNone(BytePredicate var1, byte var2);

    public int count(BytePredicate var1);

    public boolean anySatisfy(BytePredicate var1);

    public boolean allSatisfy(BytePredicate var1);

    public boolean noneSatisfy(BytePredicate var1);

    public MutableByteList toList();

    public MutableByteSet toSet();

    public MutableByteBag toBag();

    public LazyByteIterable asLazy();

    public <T> T injectInto(T var1, ObjectByteToObjectFunction<? super T, ? extends T> var2);

    default public long reduceIfEmpty(LongByteToLongFunction accumulator, long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.reduce(accumulator);
    }

    default public long reduce(LongByteToLongFunction accumulator) {
        boolean[] seenOne = new boolean[1];
        long[] result = new long[1];
        this.each(each -> {
            if (seenOne[0]) {
                result[0] = accumulator.valueOf(result[0], each);
            } else {
                seenOne[0] = true;
                result[0] = each;
            }
        });
        if (!seenOne[0]) {
            throw new NoSuchElementException();
        }
        return result[0];
    }

    default public RichIterable<ByteIterable> chunk(int size) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    public long sum();

    default public IntSummaryStatistics summaryStatistics() {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    public byte max();

    public byte maxIfEmpty(byte var1);

    public byte min();

    public byte minIfEmpty(byte var1);

    public double average();

    default public double averageIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.average();
    }

    public double median();

    default public double medianIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.median();
    }

    public byte[] toSortedArray();

    public MutableByteList toSortedList();
}

