/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction0;
import org.eclipse.collections.api.block.function.primitive.FloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToFloatFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortFloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.ImmutableShortFloatMap;
import org.eclipse.collections.api.map.primitive.MutableFloatShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortFloatMap;
import org.eclipse.collections.api.map.primitive.ShortFloatMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortFloatPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.factory.primitive.ShortFloatMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedShortFloatMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;

public class UnmodifiableShortFloatMap
implements MutableShortFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableShortFloatMap map;

    public UnmodifiableShortFloatMap(MutableShortFloatMap map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableShortFloatMap on a null map");
        }
        this.map = map;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public void put(short key, float value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    @Override
    public void putPair(ShortFloatPair keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    @Override
    public void putAll(ShortFloatMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public void updateValues(ShortFloatToFloatFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValues() on " + this.getClass().getSimpleName());
    }

    @Override
    public void removeKey(short key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    @Override
    public void remove(short key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public float removeKeyIfAbsent(short key, float value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    @Override
    public float getIfAbsentPut(short key, float value) {
        return this.map.getIfAbsentPut(key, () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Override
    public float getIfAbsentPut(short key, FloatFunction0 function) {
        return this.map.getIfAbsentPut(key, () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Override
    public float getIfAbsentPutWithKey(short key, ShortToFloatFunction function) {
        return this.map.getIfAbsentPut(key, () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Override
    public <P> float getIfAbsentPutWith(short key, FloatFunction<? super P> function, P parameter) {
        return this.map.getIfAbsentPut(key, () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Override
    public float updateValue(short key, float initialValueIfAbsent, FloatToFloatFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public float get(short key) {
        return this.map.get(key);
    }

    @Override
    public float getIfAbsent(short key, float ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    @Override
    public float getOrThrow(short key) {
        return this.map.getOrThrow(key);
    }

    @Override
    public boolean containsKey(short key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(float value) {
        return this.map.containsValue(value);
    }

    @Override
    public void forEachValue(FloatProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    @Override
    public void forEachKey(ShortProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ShortFloatProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    @Override
    public LazyShortIterable keysView() {
        return this.map.keysView();
    }

    @Override
    public RichIterable<ShortFloatPair> keyValuesView() {
        return this.map.keyValuesView();
    }

    @Override
    public MutableFloatShortMap flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    @Override
    public MutableShortFloatMap select(ShortFloatPredicate predicate) {
        return this.map.select(predicate);
    }

    @Override
    public MutableShortFloatMap reject(ShortFloatPredicate predicate) {
        return this.map.reject(predicate);
    }

    @Override
    public MutableFloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(this.map.floatIterator());
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        this.map.forEach(procedure);
    }

    @Override
    public int count(FloatPredicate predicate) {
        return this.map.count(predicate);
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    @Override
    public MutableFloatBag select(FloatPredicate predicate) {
        return this.map.select(predicate);
    }

    @Override
    public MutableFloatBag reject(FloatPredicate predicate) {
        return this.map.reject(predicate);
    }

    @Override
    public <V> MutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        return this.map.collect((FloatToObjectFunction)function);
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    @Override
    public double sum() {
        return this.map.sum();
    }

    @Override
    public float max() {
        return this.map.max();
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    @Override
    public float min() {
        return this.map.min();
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.map.average();
    }

    @Override
    public double median() {
        return this.map.median();
    }

    @Override
    public float addToValue(short key, float toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public float[] toSortedArray() {
        return this.map.toSortedArray();
    }

    @Override
    public MutableFloatList toSortedList() {
        return this.map.toSortedList();
    }

    @Override
    public float[] toArray() {
        return this.map.toArray();
    }

    @Override
    public boolean contains(float value) {
        return this.map.contains(value);
    }

    @Override
    public boolean containsAll(float ... source) {
        return this.map.containsAll(source);
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        return this.map.containsAll(source);
    }

    @Override
    public MutableFloatList toList() {
        return this.map.toList();
    }

    @Override
    public MutableFloatSet toSet() {
        return this.map.toSet();
    }

    @Override
    public MutableFloatBag toBag() {
        return this.map.toBag();
    }

    @Override
    public LazyFloatIterable asLazy() {
        return this.map.asLazy();
    }

    @Override
    public MutableShortFloatMap withKeyValue(short key, float value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableShortFloatMap withoutKey(short key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableShortFloatMap withoutAllKeys(ShortIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableShortFloatMap asUnmodifiable() {
        return this;
    }

    @Override
    public MutableShortFloatMap asSynchronized() {
        return new SynchronizedShortFloatMap(this);
    }

    @Override
    public ImmutableShortFloatMap toImmutable() {
        return ShortFloatMaps.immutable.withAll(this);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    @Override
    public MutableShortSet keySet() {
        return UnmodifiableShortSet.of(this.map.keySet());
    }

    @Override
    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public String makeString() {
        return this.map.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return this.map.injectInto(injectedValue, function);
    }

    @Override
    public RichIterable<FloatIterable> chunk(int size) {
        return this.map.chunk(size);
    }
}

