/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IBreakpointImportParticipant;
import org.eclipse.debug.core.model.ITriggerPoint;
import org.eclipse.debug.internal.core.BreakpointImportParticipantDelegate;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.IInternalDebugCoreConstants;
import org.eclipse.debug.internal.core.Preferences;

public class BreakpointManager
implements IBreakpointManager,
IResourceChangeListener {
    private static final int ADDED = 0;
    private static final int REMOVED = 1;
    private static final int CHANGED = 2;
    private Vector<IBreakpoint> fBreakpoints;
    private HashMap<String, ArrayList<BreakpointImportParticipantDelegate>> fImportParticipants;
    private IBreakpointImportParticipant fDefaultParticipant;
    private final Set<IMarker> fPostChangMarkersChanged = new HashSet<IMarker>();
    private final Set<IMarker> fPostBuildMarkersAdded = new HashSet<IMarker>();
    private final List<IBreakpoint> fSuppressChange = new ArrayList<IBreakpoint>();
    private final HashMap<String, IConfigurationElement> fBreakpointExtensions;
    private final HashMap<IMarker, IBreakpoint> fMarkersToBreakpoints;
    private final ListenerList<IBreakpointListener> fBreakpointListeners = new ListenerList();
    private ListenerList<IBreakpointsListener> fBreakpointsListeners = new ListenerList();
    private static BreakpointManagerVisitor fgVisitor;
    private final ListenerList<IBreakpointManagerListener> fBreakpointManagerListeners = new ListenerList();
    private final Set<IBreakpoint> fTriggerPointBreakpointList = new LinkedHashSet<IBreakpoint>();
    private final Set<IBreakpoint> fTriggerPointDisabledList = new LinkedHashSet<IBreakpoint>();
    private PostChangeListener fPostChangeListener = new PostChangeListener();

    public BreakpointManager() {
        this.fMarkersToBreakpoints = new HashMap(10);
        this.fBreakpointExtensions = new HashMap(15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBreakpoints(IResource resource, boolean notify) throws CoreException {
        this.initBreakpointExtensions();
        ArrayList<IBreakpoint> added = new ArrayList<IBreakpoint>();
        IMarker[] iMarkerArray = this.getPersistedMarkers(resource);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                IBreakpoint breakpoint = this.createBreakpoint(marker);
                Set<IMarker> set = this.fPostChangMarkersChanged;
                synchronized (set) {
                    this.fPostBuildMarkersAdded.add(marker);
                }
                if (breakpoint.isRegistered()) {
                    added.add(breakpoint);
                }
                if (breakpoint instanceof ITriggerPoint && ((ITriggerPoint)((Object)breakpoint)).isTriggerPoint()) {
                    this.addTriggerPoint(breakpoint);
                }
            }
            catch (DebugException e) {
                DebugPlugin.log((Throwable)((Object)e));
            }
            ++n2;
        }
        this.addBreakpoints(added.toArray(new IBreakpoint[added.size()]), notify);
    }

    protected IMarker[] getPersistedMarkers(IResource resource) throws CoreException {
        ArrayList<IMarker> delete = new ArrayList<IMarker>();
        ArrayList<IMarker> persisted = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String modelId = marker.getAttribute("org.eclipse.debug.core.id", null);
            if (modelId == null) {
                delete.add(marker);
            } else if (!marker.getAttribute("org.eclipse.debug.core.persisted", true)) {
                delete.add(marker);
            } else {
                persisted.add(marker);
            }
            ++n2;
        }
        if (!delete.isEmpty()) {
            IMarker[] delMarkers = delete.toArray(new IMarker[delete.size()]);
            IWorkspaceRunnable wr = pm -> {
                IMarker[] iMarkerArray2 = delMarkers;
                int n = delMarkers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray2[n2];
                    marker.delete();
                    ++n2;
                }
            };
            new BreakpointManagerJob(wr).schedule();
        }
        return persisted.toArray(new IMarker[persisted.size()]);
    }

    public void shutdown() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fPostChangeListener);
        this.fBreakpointListeners.clear();
        this.fBreakpointsListeners.clear();
        this.fBreakpointManagerListeners.clear();
        if (this.fImportParticipants != null) {
            this.fImportParticipants.clear();
            this.fImportParticipants = null;
            this.fDefaultParticipant = null;
        }
        if (this.fBreakpoints != null) {
            this.fBreakpoints.clear();
            this.fBreakpoints = null;
        }
        if (this.fMarkersToBreakpoints != null) {
            this.fMarkersToBreakpoints.clear();
        }
    }

    private void initBreakpointExtensions() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "breakpoints");
        IConfigurationElement[] iConfigurationElementArray = ep.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String markerType = element.getAttribute("markerType");
            String className = element.getAttribute("class");
            if (markerType == null) {
                DebugPlugin.log((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "Breakpoint extension " + element.getDeclaringExtension().getUniqueIdentifier() + " missing required attribute: markerType", null));
            } else if (className == null) {
                DebugPlugin.log((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "Breakpoint extension " + element.getDeclaringExtension().getUniqueIdentifier() + " missing required attribute: class", null));
            } else {
                this.fBreakpointExtensions.put(markerType, element);
            }
            ++n2;
        }
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    @Override
    public IBreakpoint getBreakpoint(IMarker marker) {
        this.getBreakpoints0();
        return this.fMarkersToBreakpoints.get(marker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBreakpoint[] getBreakpoints() {
        Vector<IBreakpoint> breakpoints;
        Object[] temp = new IBreakpoint[]{};
        Vector<IBreakpoint> vector = breakpoints = this.getBreakpoints0();
        synchronized (vector) {
            temp = new IBreakpoint[breakpoints.size()];
            breakpoints.copyInto(temp);
        }
        return temp;
    }

    public void ensureInitialized() {
        this.getBreakpoints0();
    }

    private synchronized Vector<IBreakpoint> getBreakpoints0() {
        if (this.fBreakpoints == null) {
            this.initializeBreakpoints();
        }
        return this.fBreakpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBreakpoint[] getBreakpoints(String modelIdentifier) {
        Vector<IBreakpoint> allBreakpoints;
        Vector<IBreakpoint> vector = allBreakpoints = this.getBreakpoints0();
        synchronized (vector) {
            ArrayList<IBreakpoint> temp = new ArrayList<IBreakpoint>(allBreakpoints.size());
            for (IBreakpoint breakpoint : allBreakpoints) {
                String id = breakpoint.getModelIdentifier();
                if (id == null || !id.equals(modelIdentifier)) continue;
                temp.add(breakpoint);
            }
            return temp.toArray(new IBreakpoint[temp.size()]);
        }
    }

    private void initializeBreakpoints() {
        this.setBreakpoints(new Vector<IBreakpoint>(10));
        try {
            this.loadBreakpoints((IResource)this.getWorkspace().getRoot(), false);
            this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
            this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fPostChangeListener, 1);
        }
        catch (CoreException ce) {
            DebugPlugin.log(ce);
            this.setBreakpoints(new Vector<IBreakpoint>(0));
        }
    }

    @Override
    public boolean isRegistered(IBreakpoint breakpoint) {
        return this.getBreakpoints0().contains(breakpoint);
    }

    @Override
    public void removeBreakpoint(IBreakpoint breakpoint, boolean delete) throws CoreException {
        this.removeBreakpoints(new IBreakpoint[]{breakpoint}, delete);
    }

    @Override
    public void removeBreakpoints(IBreakpoint[] breakpoints, boolean delete) throws CoreException {
        ArrayList<IBreakpoint> remove = new ArrayList<IBreakpoint>(breakpoints.length);
        Vector<IBreakpoint> bps = this.getBreakpoints0();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (bps.contains(breakpoint)) {
                remove.add(breakpoint);
            }
            ++n2;
        }
        if (!remove.isEmpty()) {
            for (IBreakpoint breakpoint : remove) {
                bps.remove(breakpoint);
                this.fMarkersToBreakpoints.remove(breakpoint.getMarker());
            }
            this.fireUpdate(remove, null, 1);
            this.refreshTriggerpointDisplay();
            IWorkspaceRunnable r = monitor -> {
                for (IBreakpoint breakpoint : remove) {
                    IProject project;
                    if (delete) {
                        breakpoint.delete();
                        continue;
                    }
                    IMarker marker = breakpoint.getMarker();
                    if (!marker.exists() || (project = breakpoint.getMarker().getResource().getProject()) != null && !project.isOpen()) continue;
                    breakpoint.setRegistered(false);
                }
            };
            this.getWorkspace().run(r, null, 0, null);
        }
    }

    public IBreakpoint createBreakpoint(IMarker marker) throws DebugException {
        IBreakpoint breakpoint = this.fMarkersToBreakpoints.get(marker);
        if (breakpoint != null) {
            return breakpoint;
        }
        try {
            IConfigurationElement config = this.fBreakpointExtensions.get(marker.getType());
            if (config == null) {
                throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5014, MessageFormat.format(DebugCoreMessages.BreakpointManager_Missing_breakpoint_definition, marker.getType()), null));
            }
            Object object = config.createExecutableExtension("class");
            if (object instanceof IBreakpoint) {
                breakpoint = (IBreakpoint)object;
                breakpoint.setMarker(marker);
            } else {
                DebugPlugin.log((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "Breakpoint extension " + config.getDeclaringExtension().getUniqueIdentifier() + " missing required attribute: class", null));
            }
            return breakpoint;
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    @Override
    public void addBreakpoint(IBreakpoint breakpoint) throws CoreException {
        this.addBreakpoints(new IBreakpoint[]{breakpoint});
    }

    @Override
    public void addBreakpoints(IBreakpoint[] breakpoints) throws CoreException {
        this.addBreakpoints(breakpoints, true);
    }

    private void addBreakpoints(IBreakpoint[] breakpoints, boolean notify) throws CoreException {
        ArrayList<IBreakpoint> added = new ArrayList<IBreakpoint>(breakpoints.length);
        ArrayList<IBreakpoint> update = new ArrayList<IBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (!this.getBreakpoints0().contains(breakpoint)) {
                this.verifyBreakpoint(breakpoint);
                if (breakpoint.isRegistered()) {
                    added.add(breakpoint);
                    this.getBreakpoints0().add(breakpoint);
                    this.fMarkersToBreakpoints.put(breakpoint.getMarker(), breakpoint);
                } else {
                    update.add(breakpoint);
                }
            }
            ++n2;
        }
        if (notify) {
            this.fireUpdate(added, null, 0);
        }
        if (!update.isEmpty()) {
            IWorkspaceRunnable r = monitor -> {
                Vector<IBreakpoint> bps = this.getBreakpoints0();
                for (IBreakpoint breakpoint : update) {
                    bps.add(breakpoint);
                    breakpoint.setRegistered(true);
                    this.fMarkersToBreakpoints.put(breakpoint.getMarker(), breakpoint);
                }
            };
            this.fSuppressChange.addAll(update);
            this.getWorkspace().run(r, null, 0, null);
            this.fSuppressChange.removeAll(update);
            if (notify) {
                this.fireUpdate(update, null, 0);
            }
        }
    }

    protected boolean isChangeSuppressed(IBreakpoint breakpoint) {
        return this.fSuppressChange.contains(breakpoint);
    }

    @Override
    public void fireBreakpointChanged(IBreakpoint breakpoint) {
        if (this.getBreakpoints0().contains(breakpoint)) {
            ArrayList<IBreakpoint> changed = new ArrayList<IBreakpoint>();
            changed.add(breakpoint);
            this.fireUpdate(changed, null, 2);
        }
    }

    private void verifyBreakpoint(IBreakpoint breakpoint) throws DebugException {
        try {
            String id = breakpoint.getModelIdentifier();
            if (id == null) {
                throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5014, DebugCoreMessages.BreakpointManager_Missing_model_identifier, null));
            }
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                if (fgVisitor == null) {
                    fgVisitor = new BreakpointManagerVisitor();
                }
                delta.accept((IResourceDeltaVisitor)fgVisitor);
                fgVisitor.update();
            }
            catch (CoreException ce) {
                DebugPlugin.log(ce);
            }
        }
    }

    @Override
    public void addBreakpointListener(IBreakpointListener listener) {
        this.fBreakpointListeners.add((Object)listener);
    }

    @Override
    public void removeBreakpointListener(IBreakpointListener listener) {
        this.fBreakpointListeners.remove((Object)listener);
    }

    private void fireUpdate(List<IBreakpoint> breakpoints, List<IMarkerDelta> deltas, int update) {
        if (breakpoints.isEmpty()) {
            return;
        }
        IBreakpoint[] bpArray = breakpoints.toArray(new IBreakpoint[breakpoints.size()]);
        IMarkerDelta[] deltaArray = new IMarkerDelta[bpArray.length];
        if (deltas != null) {
            deltaArray = deltas.toArray(deltaArray);
        }
        this.getBreakpointNotifier().notify(bpArray, deltaArray, update);
        this.getBreakpointsNotifier().notify(bpArray, deltaArray, update);
    }

    protected void setBreakpoints(Vector<IBreakpoint> breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    @Override
    public boolean hasBreakpoints() {
        return !this.getBreakpoints0().isEmpty();
    }

    @Override
    public void addBreakpointListener(IBreakpointsListener listener) {
        this.fBreakpointsListeners.add((Object)listener);
    }

    @Override
    public void removeBreakpointListener(IBreakpointsListener listener) {
        this.fBreakpointsListeners.remove((Object)listener);
    }

    private BreakpointNotifier getBreakpointNotifier() {
        return new BreakpointNotifier();
    }

    private BreakpointsNotifier getBreakpointsNotifier() {
        return new BreakpointsNotifier();
    }

    @Override
    public boolean isEnabled() {
        return Platform.getPreferencesService().getBoolean(DebugPlugin.getUniqueIdentifier(), IInternalDebugCoreConstants.PREF_BREAKPOINT_MANAGER_ENABLED_STATE, true, null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            Preferences.setBoolean(DebugPlugin.getUniqueIdentifier(), IInternalDebugCoreConstants.PREF_BREAKPOINT_MANAGER_ENABLED_STATE, enabled, null);
            this.touchAllBreakpoints();
            new BreakpointManagerNotifier().notify(enabled);
        }
    }

    @Override
    public void addBreakpointManagerListener(IBreakpointManagerListener listener) {
        this.fBreakpointManagerListeners.add((Object)listener);
    }

    @Override
    public void removeBreakpointManagerListener(IBreakpointManagerListener listener) {
        this.fBreakpointManagerListeners.remove((Object)listener);
    }

    @Override
    public String getTypeName(IBreakpoint breakpoint) {
        String typeName = null;
        IMarker marker = breakpoint.getMarker();
        if (marker != null) {
            try {
                IConfigurationElement element = this.fBreakpointExtensions.get(marker.getType());
                if (element != null) {
                    typeName = element.getAttribute("name");
                }
            }
            catch (CoreException coreException) {}
        }
        return typeName;
    }

    @Override
    public IBreakpointImportParticipant[] getImportParticipants(String markertype) throws CoreException {
        this.initializeImportParticipants();
        ArrayList<BreakpointImportParticipantDelegate> list = this.fImportParticipants.get(markertype);
        if (list == null) {
            return new IBreakpointImportParticipant[]{this.fDefaultParticipant};
        }
        IBreakpointImportParticipant[] participants = new IBreakpointImportParticipant[list.size()];
        BreakpointImportParticipantDelegate delegate = null;
        int i = 0;
        while (i < list.size()) {
            delegate = list.get(i);
            participants[i] = delegate.getDelegate();
            ++i;
        }
        if (participants.length == 0) {
            return new IBreakpointImportParticipant[]{this.fDefaultParticipant};
        }
        return participants;
    }

    private synchronized void initializeImportParticipants() {
        if (this.fImportParticipants == null) {
            this.fImportParticipants = new HashMap();
            this.fDefaultParticipant = new DefaultImportParticipant();
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(DebugPlugin.getUniqueIdentifier(), "breakpointImportParticipants");
            String type = null;
            ArrayList<BreakpointImportParticipantDelegate> list = null;
            IConfigurationElement[] iConfigurationElementArray = ep.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                type = element.getAttribute("type");
                if (type != null) {
                    list = this.fImportParticipants.get(type);
                    if (list == null) {
                        list = new ArrayList();
                        this.fImportParticipants.put(type, list);
                    }
                    list.add(new BreakpointImportParticipantDelegate(element));
                }
                ++n2;
            }
        }
    }

    @Override
    public IBreakpoint[] getTriggerPoints() {
        return this.fTriggerPointBreakpointList.toArray(new IBreakpoint[0]);
    }

    @Override
    public void addTriggerPoint(IBreakpoint triggerPoint) throws CoreException {
        if (triggerPoint == null) {
            return;
        }
        this.fTriggerPointBreakpointList.add(triggerPoint);
        new BreakpointManagerTriggerPointNotifier().notify(triggerPoint);
    }

    @Override
    public void removeTriggerPoint(IBreakpoint breakpoint) throws CoreException {
        if (breakpoint != null) {
            this.fTriggerPointBreakpointList.remove(breakpoint);
        }
    }

    @Override
    public void removeAllTriggerPoints() throws CoreException {
        IBreakpoint[] triggerPointBreakpointList;
        IBreakpoint[] iBreakpointArray = triggerPointBreakpointList = this.getTriggerPoints();
        int n = triggerPointBreakpointList.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint iBreakpoint = iBreakpointArray[n2];
            if (iBreakpoint instanceof ITriggerPoint) {
                ((ITriggerPoint)((Object)iBreakpoint)).setTriggerPoint(false);
            }
            ++n2;
        }
        this.refreshTriggerpointDisplay();
    }

    @Override
    public boolean hasActiveTriggerPoints() {
        if (this.fTriggerPointBreakpointList.isEmpty()) {
            return false;
        }
        for (IBreakpoint iBreakpoint : this.fTriggerPointBreakpointList) {
            try {
                if (!iBreakpoint.isEnabled()) continue;
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableTriggerPoints(IBreakpoint[] triggerPoints, boolean enable) {
        IBreakpoint[] triggerPointArray = triggerPoints;
        if (triggerPoints == null) {
            if (enable) {
                Set<IBreakpoint> set = this.fTriggerPointDisabledList;
                synchronized (set) {
                    triggerPointArray = this.fTriggerPointDisabledList.toArray(new IBreakpoint[0]);
                }
            } else {
                triggerPointArray = this.getTriggerPoints();
            }
        }
        ArrayList<IBreakpoint> toDisable = new ArrayList<IBreakpoint>();
        IBreakpoint[] iBreakpointArray = triggerPointArray;
        int n = triggerPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint iBreakpoint = iBreakpointArray[n2];
            try {
                IMarker m = iBreakpoint.getMarker();
                if (m != null && m.exists()) {
                    if (!enable && iBreakpoint.isEnabled()) {
                        toDisable.add(iBreakpoint);
                    }
                    iBreakpoint.setEnabled(enable);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        Set<IBreakpoint> set = this.fTriggerPointDisabledList;
        synchronized (set) {
            this.fTriggerPointDisabledList.clear();
            if (!enable) {
                this.fTriggerPointDisabledList.addAll(toDisable);
            }
        }
    }

    @Override
    public void refreshTriggerpointDisplay() {
        this.touchAllBreakpoints();
    }

    private void touchAllBreakpoints() {
        IWorkspaceRunnable runnable = monitor -> {
            IBreakpoint[] iBreakpointArray = this.getBreakpoints();
            int n = iBreakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                try {
                    breakpoint.getMarker().setAttribute("org.eclipse.debug.core.enabled", breakpoint.isEnabled());
                }
                catch (CoreException coreException) {}
                ++n2;
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 1, null);
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
        }
    }

    class BreakpointManagerJob
    extends Job {
        private final IWorkspaceRunnable fRunnable;

        public BreakpointManagerJob(IWorkspaceRunnable wRunnable) {
            super("breakpoint manager job");
            this.fRunnable = wRunnable;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                BreakpointManager.this.getWorkspace().run(this.fRunnable, null, 0, null);
            }
            catch (CoreException ce) {
                DebugPlugin.log(ce);
            }
            return new Status(0, DebugPlugin.getUniqueIdentifier(), 0, "", null);
        }
    }

    class BreakpointManagerNotifier
    implements ISafeRunnable {
        private IBreakpointManagerListener fListener;
        private boolean fManagerEnabled;

        BreakpointManagerNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "An exception occurred during breakpoint change notification.", exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            this.fListener.breakpointManagerEnablementChanged(this.fManagerEnabled);
        }

        public void notify(boolean enabled) {
            this.fManagerEnabled = enabled;
            Iterator iterator = BreakpointManager.this.fBreakpointManagerListeners.iterator();
            while (iterator.hasNext()) {
                IBreakpointManagerListener iBreakpointManagerListener;
                this.fListener = iBreakpointManagerListener = (IBreakpointManagerListener)iterator.next();
                SafeRunner.run((ISafeRunnable)this);
            }
            this.fListener = null;
        }
    }

    class BreakpointManagerTriggerPointNotifier
    implements ISafeRunnable {
        private IBreakpointManagerListener fListener;
        private IBreakpoint fManagerTriggerPoint;

        BreakpointManagerTriggerPointNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "An exception occurred during breakpoint change notification.", exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            this.fListener.breakpointManagerTriggerPointChanged(this.fManagerTriggerPoint);
        }

        public void notify(IBreakpoint triggerBreakpoint) {
            this.fManagerTriggerPoint = triggerBreakpoint;
            Iterator iterator = BreakpointManager.this.fBreakpointManagerListeners.iterator();
            while (iterator.hasNext()) {
                IBreakpointManagerListener iBreakpointManagerListener;
                this.fListener = iBreakpointManagerListener = (IBreakpointManagerListener)iterator.next();
                SafeRunner.run((ISafeRunnable)this);
            }
            this.fListener = null;
        }
    }

    class BreakpointManagerVisitor
    implements IResourceDeltaVisitor {
        private List<IMarker> fMoved = new ArrayList<IMarker>();
        private List<IBreakpoint> fRemoved = new ArrayList<IBreakpoint>();
        private List<IBreakpoint> fAdded = new ArrayList<IBreakpoint>();
        private List<IBreakpoint> fChanged = new ArrayList<IBreakpoint>();
        private List<IMarkerDelta> fChangedDeltas = new ArrayList<IMarkerDelta>();

        BreakpointManagerVisitor() {
        }

        protected void reset() {
            this.fMoved.clear();
            this.fRemoved.clear();
            this.fAdded.clear();
            this.fChanged.clear();
            this.fChangedDeltas.clear();
        }

        public void update() {
            if (!this.fMoved.isEmpty()) {
                IWorkspaceRunnable wRunnable = monitor -> {
                    for (IMarker marker : this.fMoved) {
                        marker.delete();
                    }
                };
                try {
                    BreakpointManager.this.getWorkspace().run(wRunnable, null, 0, null);
                }
                catch (CoreException coreException) {}
            }
            if (!this.fRemoved.isEmpty()) {
                try {
                    BreakpointManager.this.removeBreakpoints(this.fRemoved.toArray(new IBreakpoint[this.fRemoved.size()]), false);
                }
                catch (CoreException e) {
                    DebugPlugin.log(e);
                }
            }
            if (!this.fAdded.isEmpty()) {
                try {
                    IWorkspaceRunnable runnable = monitor -> {
                        for (IBreakpoint breakpoint : this.fAdded) {
                            breakpoint.getMarker().setAttribute("org.eclipse.debug.core.breakpointIsDeleted", false);
                            breakpoint.setRegistered(true);
                        }
                    };
                    BreakpointManager.this.getWorkspace().run(runnable, null, 0, null);
                    BreakpointManager.this.addBreakpoints(this.fAdded.toArray(new IBreakpoint[this.fAdded.size()]), false);
                }
                catch (CoreException e) {
                    DebugPlugin.log(e);
                }
            }
            if (!this.fChanged.isEmpty()) {
                BreakpointManager.this.fireUpdate(this.fChanged, this.fChangedDeltas, 2);
            }
            this.reset();
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            if ((delta.getFlags() & 0x4000) != 0 && (delta.getFlags() & 0x1000) == 0) {
                this.handleProjectResourceOpenStateChange(delta.getResource());
                return false;
            }
            IMarkerDelta[] iMarkerDeltaArray = delta.getMarkerDeltas();
            int n = iMarkerDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                if (markerDelta.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER)) {
                    switch (markerDelta.getKind()) {
                        case 1: {
                            this.handleAddBreakpoint(delta, markerDelta.getMarker(), markerDelta);
                            break;
                        }
                        case 2: {
                            this.handleRemoveBreakpoint(markerDelta.getMarker());
                            break;
                        }
                        case 4: {
                            this.handleChangeBreakpoint(markerDelta.getMarker(), markerDelta);
                            break;
                        }
                    }
                }
                ++n2;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleAddBreakpoint(IResourceDelta rDelta, IMarker marker, IMarkerDelta mDelta) {
            if ((rDelta.getFlags() & 0x1000) != 0) {
                if (BreakpointManager.this.getBreakpoint(marker) == null) {
                    this.fMoved.add(marker);
                }
            } else {
                Set set = BreakpointManager.this.fPostChangMarkersChanged;
                synchronized (set) {
                    if (BreakpointManager.this.fPostChangMarkersChanged.contains(marker)) {
                        this.handleChangeBreakpoint(marker, mDelta);
                        BreakpointManager.this.fPostChangMarkersChanged.remove(marker);
                    } else if (marker.getAttribute("org.eclipse.debug.core.breakpointIsDeleted", false) && BreakpointManager.this.getBreakpoint(marker) == null) {
                        try {
                            IBreakpoint breakpoint = this.findMatchingBreakpoint(marker);
                            if (breakpoint != null) {
                                BreakpointManager.this.removeBreakpoint(breakpoint, true);
                            }
                            this.fAdded.add(BreakpointManager.this.createBreakpoint(marker));
                        }
                        catch (CoreException e) {
                            DebugPlugin.log(e);
                        }
                    }
                    BreakpointManager.this.fPostBuildMarkersAdded.add(marker);
                }
            }
        }

        private IBreakpoint findMatchingBreakpoint(IMarker marker) {
            try {
                Integer line = (Integer)marker.getAttribute("lineNumber");
                for (IBreakpoint breakpoint : BreakpointManager.this.getBreakpoints0()) {
                    IMarker bpMarker = breakpoint.getMarker();
                    if (bpMarker == null || !marker.getResource().equals((Object)bpMarker.getResource()) || bpMarker.getAttribute("lineNumber", -1) != (line == null ? -1 : line)) continue;
                    return breakpoint;
                }
            }
            catch (CoreException coreException) {}
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleRemoveBreakpoint(IMarker marker) {
            Set set = BreakpointManager.this.fPostChangMarkersChanged;
            synchronized (set) {
                BreakpointManager.this.fPostChangMarkersChanged.remove(marker);
                BreakpointManager.this.fPostBuildMarkersAdded.remove(marker);
            }
            IBreakpoint breakpoint = BreakpointManager.this.getBreakpoint(marker);
            if (breakpoint != null) {
                this.fRemoved.add(breakpoint);
            }
        }

        protected void handleChangeBreakpoint(IMarker marker, IMarkerDelta delta) {
            IBreakpoint breakpoint = BreakpointManager.this.getBreakpoint(marker);
            if (breakpoint != null && BreakpointManager.this.isRegistered(breakpoint) && !BreakpointManager.this.isChangeSuppressed(breakpoint)) {
                this.fChanged.add(breakpoint);
                this.fChangedDeltas.add(delta);
            }
        }

        private void handleProjectResourceOpenStateChange(IResource project) {
            if (!project.isAccessible()) {
                for (IBreakpoint breakpoint : (Vector)BreakpointManager.this.getBreakpoints0().clone()) {
                    IResource markerResource = breakpoint.getMarker().getResource();
                    if (!project.getFullPath().isPrefixOf(markerResource.getFullPath())) continue;
                    this.fRemoved.add(breakpoint);
                }
                return;
            }
            try {
                BreakpointManager.this.loadBreakpoints(project, true);
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }
    }

    class BreakpointNotifier
    implements ISafeRunnable {
        private IBreakpointListener fListener;
        private int fType;
        private IMarkerDelta fDelta;
        private IBreakpoint fBreakpoint;

        BreakpointNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "An exception occurred during breakpoint change notification.", exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.breakpointAdded(this.fBreakpoint);
                    break;
                }
                case 1: {
                    this.fListener.breakpointRemoved(this.fBreakpoint, this.fDelta);
                    break;
                }
                case 2: {
                    this.fListener.breakpointChanged(this.fBreakpoint, this.fDelta);
                    break;
                }
            }
        }

        public void notify(IBreakpoint[] breakpoints, IMarkerDelta[] deltas, int update) {
            this.fType = update;
            Iterator iterator = BreakpointManager.this.fBreakpointListeners.iterator();
            while (iterator.hasNext()) {
                IBreakpointListener iBreakpointListener;
                this.fListener = iBreakpointListener = (IBreakpointListener)iterator.next();
                int j = 0;
                while (j < breakpoints.length) {
                    this.fBreakpoint = breakpoints[j];
                    this.fDelta = deltas[j];
                    SafeRunner.run((ISafeRunnable)this);
                    ++j;
                }
            }
            this.fListener = null;
            this.fDelta = null;
            this.fBreakpoint = null;
        }
    }

    class BreakpointsNotifier
    implements ISafeRunnable {
        private IBreakpointsListener fListener;
        private int fType;
        private IMarkerDelta[] fDeltas;
        private IBreakpoint[] fNotifierBreakpoints;

        BreakpointsNotifier() {
        }

        public void handleException(Throwable exception) {
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "An exception occurred during breakpoint change notification.", exception);
            DebugPlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 0: {
                    this.fListener.breakpointsAdded(this.fNotifierBreakpoints);
                    break;
                }
                case 1: {
                    this.fListener.breakpointsRemoved(this.fNotifierBreakpoints, this.fDeltas);
                    break;
                }
                case 2: {
                    this.fListener.breakpointsChanged(this.fNotifierBreakpoints, this.fDeltas);
                    break;
                }
            }
        }

        public void notify(IBreakpoint[] breakpoints, IMarkerDelta[] deltas, int update) {
            this.fType = update;
            this.fNotifierBreakpoints = breakpoints;
            this.fDeltas = deltas;
            Iterator iterator = BreakpointManager.this.fBreakpointsListeners.iterator();
            while (iterator.hasNext()) {
                IBreakpointsListener iBreakpointsListener;
                this.fListener = iBreakpointsListener = (IBreakpointsListener)iterator.next();
                SafeRunner.run((ISafeRunnable)this);
            }
            this.fDeltas = null;
            this.fNotifierBreakpoints = null;
            this.fListener = null;
        }
    }

    class DefaultImportParticipant
    implements IBreakpointImportParticipant {
        DefaultImportParticipant() {
        }

        @Override
        public boolean matches(Map<String, Object> attributes, IBreakpoint breakpoint) throws CoreException {
            IMarker marker = breakpoint.getMarker();
            String type = (String)attributes.get("type");
            Integer line = (Integer)attributes.get("lineNumber");
            Object localline = marker.getAttribute("lineNumber");
            String localtype = marker.getType();
            if (type.equals(localtype)) {
                if (line != null && line.equals(localline)) {
                    return true;
                }
                if (line == null) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void verify(IBreakpoint breakpoint) throws CoreException {
        }
    }

    class PostChangeListener
    implements IResourceChangeListener {
        private PostChangeVisitor fVisitor;

        PostChangeListener() {
            this.fVisitor = new PostChangeVisitor();
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                try {
                    delta.accept((IResourceDeltaVisitor)this.fVisitor);
                }
                catch (CoreException ce) {
                    DebugPlugin.log(ce);
                }
            }
        }
    }

    class PostChangeVisitor
    implements IResourceDeltaVisitor {
        PostChangeVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta == null) {
                return false;
            }
            IMarkerDelta[] iMarkerDeltaArray = delta.getMarkerDeltas();
            int n = iMarkerDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                if (markerDelta.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER)) {
                    switch (markerDelta.getKind()) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 4: {
                            IMarker marker = markerDelta.getMarker();
                            Set set = BreakpointManager.this.fPostChangMarkersChanged;
                            synchronized (set) {
                                if (!BreakpointManager.this.fPostBuildMarkersAdded.contains(marker)) {
                                    BreakpointManager.this.fPostChangMarkersChanged.add(marker);
                                }
                                break;
                            }
                        }
                    }
                }
                ++n2;
            }
            return true;
        }
    }
}

