/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.task.ui.contributions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.platform.loader.BundleClassLoaderFactory;
import org.eclipse.egf.core.platform.loader.IBundleClassLoader;
import org.eclipse.egf.model.ftask.Task;
import org.eclipse.egf.task.EGFTaskPlugin;
import org.eclipse.egf.task.ui.EGFTaskUIPlugin;
import org.eclipse.egf.task.ui.contributions.TaskImplementationOpenAction;
import org.eclipse.egf.task.ui.contributions.TaskMenuContributor;
import org.eclipse.egf.task.ui.l10n.EGFTaskUIMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class OpenJavaTaskImplementationMenuContributor
extends TaskMenuContributor {
    public static final String OPEN_TASK_IMPLEMENTATION_ACTION_ID = "open-java-task-implementation";

    protected String getExpectedKind() {
        return EGFTaskPlugin.KIND_JAVA;
    }

    protected TaskImplementationOpenAction createAction(Task task) {
        OpenAction openAction = new OpenAction(task);
        openAction.setText(EGFTaskUIMessages.TaskImplementationMenuContributor_openAction_label);
        return openAction;
    }

    public static class FindOperation
    implements IRunnableWithProgress {
        private String _fqn;
        private Resource _resource;
        private IType _type;

        public FindOperation(Resource resource, String fqn) {
            this._resource = resource;
            this._fqn = fqn;
        }

        public IType getType() {
            return this._type;
        }

        public URI getURI() {
            URIConverter converter;
            Resource resource = this._resource;
            if (resource == null) {
                return null;
            }
            URI uri = resource.getURI();
            if (uri != null && resource.getResourceSet() != null && (converter = resource.getResourceSet().getURIConverter()) != null) {
                uri = converter.normalize(uri);
            }
            return uri;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                try {
                    URI uri = this.getURI();
                    if (uri.isPlatformResource()) {
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(uri.toPlatformString(true)));
                        IJavaProject project = JavaCore.create((IProject)resource.getProject());
                        this._type = project.findType(this._fqn, monitor);
                    } else {
                        IPlatformFcore fcore = null;
                        Bundle bundle = null;
                        if (this._resource instanceof IPlatformFcoreProvider) {
                            fcore = ((IPlatformFcoreProvider)this._resource).getIPlatformFcore();
                        }
                        if (fcore == null) {
                            throw new InvocationTargetException((Throwable)new CoreException(EGFTaskUIPlugin.getDefault().newStatus(4, NLS.bind((String)EGFTaskUIMessages.OpenTaskImplementationMenuContributor_unable_to_find_platform_fcore, (Object)this._resource.getURI()), null)));
                        }
                        Class clazz = null;
                        bundle = fcore.getPlatformBundle().getBundle();
                        if (bundle != null) {
                            clazz = bundle.loadClass(this._fqn);
                        } else {
                            IBundleClassLoader loader = BundleClassLoaderFactory.getBundleClassLoader((IPluginModelBase)fcore.getPluginModelBase());
                            clazz = loader.loadClass(this._fqn);
                        }
                        if (clazz == null) {
                            throw new InvocationTargetException((Throwable)new CoreException(EGFTaskUIPlugin.getDefault().newStatus(4, NLS.bind((String)EGFTaskUIMessages.OpenTaskImplementationMenuContributor_unable_to_load_class, (Object)this._fqn), null)));
                        }
                        String id = fcore.getPlatformBundle().getBundleId();
                        if (!PDECore.getDefault().getSearchablePluginsManager().isInJavaSearch(id)) {
                            PDECore.getDefault().getSearchablePluginsManager().addToJavaSearch(new IPluginModelBase[]{fcore.getPluginModelBase()});
                        }
                        TypeSearchRequestor requestor = new TypeSearchRequestor();
                        SearchEngine engine = new SearchEngine(null);
                        engine.searchAllTypeNames(clazz.getPackage().getName().toCharArray(), 0, clazz.getSimpleName().toCharArray(), 0, 10, SearchEngine.createWorkspaceScope(), (TypeNameMatchRequestor)requestor, 3, monitor);
                        this._type = requestor.getMatched();
                    }
                }
                catch (Throwable t) {
                    throw new InvocationTargetException((Throwable)new CoreException(EGFTaskUIPlugin.getDefault().newStatus(4, EGFTaskUIMessages.OpenTaskImplementationMenuContributor_error_message, t)));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected static class OpenAction
    extends TaskImplementationOpenAction {
        public OpenAction(Task task) {
            super(task, OpenJavaTaskImplementationMenuContributor.OPEN_TASK_IMPLEMENTATION_ACTION_ID);
        }

        protected boolean doRun() throws Exception {
            FindOperation operation = new FindOperation(this.getTask().eResource(), this.getImplementation());
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
            if (operation.getType() == null) {
                return false;
            }
            JavaUI.openInEditor((IJavaElement)operation.getType());
            return true;
        }
    }

    private static class TypeSearchRequestor
    extends TypeNameMatchRequestor {
        private IType _matched;

        public void acceptTypeNameMatch(TypeNameMatch match) {
            this._matched = match.getType();
        }

        public IType getMatched() {
            return this._matched;
        }
    }
}

