/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.language.ui.outline;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mwe2.language.mwe2.Assignment;
import org.eclipse.emf.mwe2.language.mwe2.Component;
import org.eclipse.emf.mwe2.language.mwe2.DeclaredProperty;
import org.eclipse.emf.mwe2.language.mwe2.Module;
import org.eclipse.emf.mwe2.language.mwe2.Mwe2Package;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.DefaultOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.utils.TextStyle;
import org.eclipse.xtext.ui.label.StylerFactory;

public class Mwe2OutlineTreeProvider
extends DefaultOutlineTreeProvider {
    private static final String COMPONENT_TYPE_SEPARATOR = " : ";
    @Inject
    private StylerFactory stylerFactory;
    @Inject
    private IImageHelper imageHelper;

    protected void _createChildren(DocumentRootNode parentNode, Module module) {
        this.createEStructuralFeatureNode((IOutlineNode)parentNode, (EObject)module, (EStructuralFeature)Mwe2Package.Literals.MODULE__IMPORTS, this.imageHelper.getImage("impc_obj.gif"), "import declarations", false);
        this.createEStructuralFeatureNode((IOutlineNode)parentNode, (EObject)module, (EStructuralFeature)Mwe2Package.Literals.MODULE__DECLARED_PROPERTIES, this.imageHelper.getImage("settings_obj.gif"), "declared properties", false);
        if (module.getRoot() != null) {
            this.createNode((IOutlineNode)parentNode, (EObject)module.getRoot());
        }
    }

    protected boolean _isLeaf(Assignment assignment) {
        return !(assignment.getValue() instanceof Component);
    }

    protected boolean _isLeaf(DeclaredProperty property) {
        return !(property.getDefault() instanceof Component);
    }

    protected Image _image(DeclaredProperty prop) {
        return this.labelProvider.getImage((Object)prop.getDefault());
    }

    protected Object _text(Assignment assignment) {
        StyledString styledText = (StyledString)super._text((Object)assignment);
        if (assignment.getFeature() instanceof JvmOperation) {
            return this.appendSimpleName(styledText, (JvmIdentifiableElement)((JvmOperation)assignment.getFeature()).getParameters().get(0));
        }
        return styledText;
    }

    protected Object _text(Component component) {
        StyledString styledText = (StyledString)super._text((Object)component);
        if (component.getType() != null) {
            return this.appendSimpleName(styledText, (JvmIdentifiableElement)component.getType());
        }
        return styledText;
    }

    protected StyledString appendSimpleName(StyledString styledText, JvmIdentifiableElement element) {
        String typeName = element.getSimpleName();
        return styledText.append(new StyledString(COMPONENT_TYPE_SEPARATOR + typeName, this.stylerFactory.createXtextStyleAdapterStyler(this.getTypeTextStyle())));
    }

    protected TextStyle getTypeTextStyle() {
        TextStyle textStyle = new TextStyle();
        textStyle.setColor(new RGB(149, 125, 71));
        return textStyle;
    }
}

