/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteMessages;
import org.osgi.framework.Bundle;

class DebugModeHelper {
    boolean awt = false;
    boolean console = false;
    boolean setup = false;
    InputStreamReader inReader = null;
    Object display = null;
    Constructor cMB = null;
    Field fPrimaryModel = null;
    Method fasync = null;
    Method fsync = null;
    Method fSetText = null;
    Method fSetMessage = null;
    Method fOpen = null;
    Method fGetWorkbench = null;
    Class cSWT = null;
    Class cMessageDialog = null;
    Method fDoit = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    DebugModeHelper() {
    }

    protected void setupType() {
        block29: {
            if (this.setup) {
                return;
            }
            this.setup = true;
            this.console = "true".equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(ProxyPlugin.getPlugin().getBundle().getSymbolicName()) + "/remote/debug/ioconsole")));
            if (this.console) {
                return;
            }
            try {
                Bundle uiBundle = Platform.getBundle((String)"org.eclipse.ui");
                if (uiBundle == null) {
                    this.setupAWT();
                    return;
                }
                Class cPlatformUI = uiBundle.loadClass("org.eclipse.ui.PlatformUI");
                Method isWBRunning = cPlatformUI.getMethod("isWorkbenchRunning", null);
                if (!((Boolean)isWBRunning.invoke(null, null)).booleanValue()) {
                    this.setupAWT();
                    return;
                }
                this.fGetWorkbench = cPlatformUI.getMethod("getWorkbench", null);
                Object w = this.fGetWorkbench.invoke(null, null);
                if (w != null) {
                    Class cDisplay = uiBundle.loadClass("org.eclipse.swt.widgets.Display");
                    Method fGetCurrent = cDisplay.getMethod("getCurrent", null);
                    Method fGetDefault = cDisplay.getMethod("getDefault", null);
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.Runnable");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    this.fasync = cDisplay.getMethod("asyncExec", classArray);
                    Class[] classArray2 = new Class[1];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("java.lang.Runnable");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray2[0] = clazz2;
                    this.fsync = cDisplay.getMethod("syncExec", classArray2);
                    this.display = fGetCurrent.invoke(null, null);
                    if (this.display == null) {
                        this.display = fGetDefault.invoke(null, null);
                    }
                }
                if (this.display != null) {
                    Class cShell = uiBundle.loadClass("org.eclipse.swt.widgets.Shell");
                    Class cMessageBox = uiBundle.loadClass("org.eclipse.swt.widgets.MessageBox");
                    this.cMB = cMessageBox.getConstructor(cShell, Integer.TYPE);
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    this.fSetText = cMessageBox.getMethod("setText", classArray);
                    Class[] classArray3 = new Class[1];
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$1 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray3[0] = clazz3;
                    this.fSetMessage = cMessageBox.getMethod("setMessage", classArray3);
                    this.fOpen = cMessageBox.getMethod("open", null);
                    this.cSWT = uiBundle.loadClass("org.eclipse.swt.SWT");
                    this.fPrimaryModel = this.cSWT.getField("PRIMARY_MODAL");
                    break block29;
                }
                this.setupAWT();
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
    }

    protected void setupAWT() {
        try {
            this.cMessageDialog = Class.forName("org.eclipse.jem.internal.proxy.remote.MessageDialog");
            Class[] classArray = new Class[4];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz3;
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[3] = clazz4;
            this.fDoit = this.cMessageDialog.getMethod("doit", classArray);
            this.awt = true;
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        this.console = true;
    }

    public boolean debugMode(final String name) {
        boolean debugMode = "true".equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(ProxyPlugin.getPlugin().getBundle().getSymbolicName()) + "/remote/debug/debugvm")));
        if (!debugMode) {
            return debugMode;
        }
        this.setupType();
        if (this.console) {
            return this.debugModeConsole(name);
        }
        if (this.awt) {
            return this.debugModeAWT(name);
        }
        try {
            final Field fYes = this.cSWT.getField("YES");
            Field fNo = this.cSWT.getField("NO");
            Field fIcon = this.cSWT.getField("ICON_QUESTION");
            final int style = fYes.getInt(null) | fNo.getInt(null) | fIcon.getInt(null) | this.fPrimaryModel.getInt(null);
            final boolean[] db = new boolean[1];
            this.fsync.invoke(this.display, new Runnable(){

                public void run() {
                    try {
                        Object shell = DebugModeHelper.this.getActiveShell();
                        Object mb = DebugModeHelper.this.cMB.newInstance(shell, new Integer(style));
                        DebugModeHelper.this.fSetText.invoke(mb, "Debug RemoteVM?");
                        DebugModeHelper.this.fSetMessage.invoke(mb, "Do you want to start the remote vm (" + name + ") in debug mode?");
                        db[0] = fYes.get(null).equals(DebugModeHelper.this.fOpen.invoke(mb, null));
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }
            });
            return db[0];
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return this.debugModeAWT(name);
    }

    protected Object getActiveShell() {
        Object shell = null;
        try {
            Object w = this.fGetWorkbench.invoke(null, null);
            Object ww = null;
            if (w != null) {
                Class<?> cWorkbench = w.getClass();
                Method getWorkbenchWindow = cWorkbench.getMethod("getActiveWorkbenchWindow", null);
                ww = getWorkbenchWindow.invoke(w, null);
            }
            if (ww != null) {
                Class<?> cWorkbenchWindow = ww.getClass();
                Method getShell = cWorkbenchWindow.getMethod("getShell", null);
                shell = getShell.invoke(ww, null);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return shell;
    }

    protected boolean debugModeAWT(String name) {
        try {
            Integer r = (Integer)this.fDoit.invoke(null, "Debug RemoteVM?", "Do you want to start the remote vm (" + name + ") in debug mode?", "Yes", "No");
            return r == 1;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return false;
    }

    protected boolean debugModeConsole(String name) {
        this.inReader = new InputStreamReader(System.in);
        System.out.println("Do you want to start the remote vm (" + name + ") in debug mode? (Enter Y or N):");
        int r = 32;
        try {
            r = Character.toLowerCase((char)this.inReader.read());
            while (this.inReader.ready()) {
                this.inReader.read();
            }
            return r == 121;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean promptPort(final int dport) {
        if (this.awt) {
            return this.promptPortAWT(dport);
        }
        if (this.console) {
            return this.promptPortConsole(dport);
        }
        try {
            final Field fOK = this.cSWT.getField("OK");
            Field fCancel = this.cSWT.getField("CANCEL");
            Field fIcon = this.cSWT.getField("ICON_WORKING");
            final int style = fOK.getInt(null) | fCancel.getInt(null) | fIcon.getInt(null) | this.fPrimaryModel.getInt(null);
            final boolean[] ok = new boolean[1];
            this.fsync.invoke(this.display, new Runnable(){

                public void run() {
                    try {
                        Object shell = DebugModeHelper.this.getActiveShell();
                        Object mb = DebugModeHelper.this.cMB.newInstance(shell, new Integer(style));
                        DebugModeHelper.this.fSetText.invoke(mb, "Connect Debugger to RemoteVM!");
                        DebugModeHelper.this.fSetMessage.invoke(mb, "You must now attach the debugger to port number " + dport + ". Press OK when the debugger is attached. The program will not continue properly without the debugger being attached. Press Cancel if you could not connect the debugger. This will still cause an error, but it will clean up better.");
                        ok[0] = fOK.get(null).equals(DebugModeHelper.this.fOpen.invoke(mb, null));
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }
            });
            return ok[0];
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return false;
    }

    protected boolean promptPortAWT(int dport) {
        try {
            Integer r = (Integer)this.fDoit.invoke(null, "Connect Debugger to RemoteVM!", "You must now attach the debugger to port number " + dport + ". Press OK when the debugger is attached. The program will not continue properly without the debugger being attached. Press Cancel if you could not connect the debugger. This will still cause an error, but it will clean up better.", "OK", "Cancel");
            return r == 1;
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return false;
    }

    protected boolean promptPortConsole(int dport) {
        System.out.println("You must now attach the debugger to port number " + dport + ". Enter 'y' when the debugger is attached. The program will not continue properly without the debugger being attached. Press 'n' if you could not connect the debugger. This will still cause an error, but it will clean up better. Enter 'y' or 'n':");
        int r = 32;
        try {
            r = Character.toLowerCase((char)this.inReader.read());
            while (this.inReader.ready()) {
                this.inReader.read();
            }
            return r == 121;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void displayErrorMessage(final String title, final String msg) {
        this.setupType();
        if (this.console) {
            this.displayErrorMessageConsole(title, msg);
        } else if (this.awt) {
            this.displayErrorMessageAWT(title, msg);
        } else {
            try {
                Field fOK = this.cSWT.getField("OK");
                Field fIcon = this.cSWT.getField("ICON_ERROR");
                final int style = fOK.getInt(null) | fIcon.getInt(null) | this.fPrimaryModel.getInt(null);
                this.fasync.invoke(this.display, new Runnable(){

                    public void run() {
                        try {
                            Object shell = DebugModeHelper.this.getActiveShell();
                            Object mb = DebugModeHelper.this.cMB.newInstance(shell, new Integer(style));
                            DebugModeHelper.this.fSetText.invoke(mb, title);
                            DebugModeHelper.this.fSetMessage.invoke(mb, msg);
                            DebugModeHelper.this.fOpen.invoke(mb, null);
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {}
                    }
                });
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    protected void displayErrorMessageConsole(String title, String msg) {
        System.out.println("Error: " + title);
        System.out.println("       " + msg);
    }

    protected void displayErrorMessageAWT(String title, String msg) {
        try {
            Object[] objectArray = new Object[4];
            objectArray[0] = title;
            objectArray[1] = msg;
            objectArray[2] = ProxyRemoteMessages.OK_7;
            this.fDoit.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
    }
}

