/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.utility.EmptyTextRange;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.ManagedType;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.XmlFile;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmManagedType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlDefinition;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.resource.ResourceMappingFile;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericOrmXml
extends AbstractOrmXmlContextModel<MappingFileRef>
implements OrmXml {
    protected final JptXmlResource xmlResource;
    protected JptResourceType resourceType;
    protected OrmXmlDefinition definition;
    protected EntityMappings root;

    public GenericOrmXml(MappingFileRef parent, JptXmlResource xmlResource) {
        super(parent);
        this.checkXmlResource(xmlResource);
        this.xmlResource = xmlResource;
        this.resourceType = xmlResource.getResourceType();
        this.definition = this.buildDefinition();
        XmlEntityMappings xmlEntityMappings = (XmlEntityMappings)xmlResource.getRootObject();
        if (xmlEntityMappings != null) {
            this.root = this.buildRoot(xmlEntityMappings);
        }
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.syncEntityMappings(monitor);
    }

    protected void syncEntityMappings(IProgressMonitor monitor) {
        this.syncEntityMappings(true, monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateEntityMappings(monitor);
    }

    protected void updateEntityMappings(IProgressMonitor monitor) {
        this.syncEntityMappings(false, monitor);
    }

    protected void syncEntityMappings(boolean sync, IProgressMonitor monitor) {
        XmlEntityMappings oldXmlEntityMappings = this.root == null ? null : this.root.getXmlEntityMappings();
        XmlEntityMappings newXmlEntityMappings = (XmlEntityMappings)this.xmlResource.getRootObject();
        JptResourceType newResourceType = this.xmlResource.getResourceType();
        if (oldXmlEntityMappings != newXmlEntityMappings || newXmlEntityMappings == null || ObjectTools.notEquals((Object)this.resourceType, (Object)newResourceType)) {
            this.setRoot(null);
        }
        this.resourceType = newResourceType;
        this.definition = this.buildDefinition();
        if (newXmlEntityMappings != null) {
            if (this.root == null) {
                this.setRoot(this.buildRoot(newXmlEntityMappings));
            } else if (sync) {
                this.root.synchronizeWithResourceModel(monitor);
            } else {
                this.root.update(monitor);
            }
        }
    }

    @Override
    public JptResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public OrmXmlDefinition getDefinition() {
        return this.definition;
    }

    protected OrmXmlDefinition buildDefinition() {
        return (OrmXmlDefinition)this.getJpaPlatform().getResourceDefinition(this.resourceType);
    }

    @Override
    public EntityMappings getRoot() {
        return this.root;
    }

    protected void setRoot(EntityMappings root) {
        EntityMappings old = this.root;
        this.root = root;
        this.firePropertyChanged("root", old, root);
        this.firePropertyChanged("root", old, root);
    }

    protected EntityMappings buildRoot(XmlEntityMappings xmlEntityMappings) {
        return this.getContextModelFactory().buildEntityMappings(this, xmlEntityMappings);
    }

    @Override
    public Iterable<Query> getMappingFileQueries() {
        return this.root != null ? this.root.getMappingFileQueries() : EmptyIterable.instance();
    }

    @Override
    public Iterable<Generator> getMappingFileGenerators() {
        return this.root != null ? this.root.getMappingFileGenerators() : EmptyIterable.instance();
    }

    protected void checkXmlResource(JptXmlResource resource) {
        if (resource == null) {
            throw new NullPointerException();
        }
        if (!resource.getContentType().isKindOf(ResourceMappingFile.Root.CONTENT_TYPE)) {
            throw new IllegalArgumentException("Content type is not 'mapping file': " + resource);
        }
    }

    @Override
    public IResource getResource() {
        return this.xmlResource.getFile();
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.xmlResource.getFile());
    }

    @Override
    protected OrmXml getOrmXml() {
        return this;
    }

    @Override
    public JptXmlResource getXmlResource() {
        return this.xmlResource;
    }

    @Override
    public boolean isLatestSupportedVersion() {
        return XmlFile.XmlFile_.isLatestSupportedVersion(this);
    }

    @Override
    public boolean isIn(IFolder folder) {
        IResource member = folder.findMember(this.xmlResource.getFile().getName());
        IFile file = this.xmlResource.getFile();
        return ObjectTools.equals((Object)member, (Object)file);
    }

    @Override
    public boolean isGenericMappingFile() {
        return XmlFile.XmlFile_.isGenericMappingFile(this);
    }

    @Override
    public Object getResourceMappingFile() {
        return this.xmlResource;
    }

    @Override
    public OrmPersistentType getPersistentType(String name) {
        return this.root == null ? null : this.root.getPersistentType(name);
    }

    @Override
    public void addRootStructureNodesTo(JpaFile jpaFile, Collection<JpaStructureNode> rootStructureNodes) {
        if (this.root != null) {
            this.root.addRootStructureNodesTo(jpaFile, rootStructureNodes);
        }
    }

    public Iterable<OrmPersistentType> getPersistentTypes() {
        return this.root != null ? this.root.getPersistentTypes() : EmptyIterable.instance();
    }

    public Iterable<OrmManagedType> getManagedTypes() {
        return this.root != null ? this.root.getManagedTypes() : EmptyIterable.instance();
    }

    @Override
    public ManagedType getManagedType(String typeName) {
        return this.root == null ? null : this.root.getManagedType(typeName);
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(IType type) {
        return this.root != null ? this.root.createDeleteTypeEdits(type) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.root != null ? this.root.createRenameTypeEdits(originalType, newName) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.root != null ? this.root.createMoveTypeEdits(originalType, newPackage) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.root != null ? this.root.createRenamePackageEdits(originalPackage, newName) : IterableTools.emptyIterable();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.root != null) {
            this.root.validate(messages, reporter);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return EmptyTextRange.instance();
    }
}

