/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.core.model.ObjectMappingProfilePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.tools.Profile;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

@Entity
@Table(name="COMP_ID")
class CompIdentifierPO
extends ComponentIdentifier
implements ICompIdentifierPO,
PersistenceWeaved,
PersistenceObject {
    private transient Long m_id;
    private transient Integer m_version;
    private Long m_parentProjectId;
    private IObjectMappingProfilePO m_profilePO;
    static final long serialVersionUID = -3902008854829596061L;

    CompIdentifierPO() {
        this.m_id = null;
        this.m_parentProjectId = null;
        this.m_profilePO = null;
    }

    @Override
    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    @CollectionTable(name="NEIGHBOURS")
    @Column(name="NEIGHBOUR", length=4000)
    @OrderColumn(name="IDX")
    @JoinColumn(name="FK_COMP_ID")
    @BatchFetch(value=BatchFetchType.JOIN)
    public List<String> getNeighbours() {
        return super.getNeighbours();
    }

    @Override
    public void setNeighbours(List<String> neighbours) {
        super.setNeighbours(neighbours);
    }

    @Basic
    @Column(name="COMP_CLASS_NAME", length=4000)
    public String getComponentClassName() {
        return super.getComponentClassName();
    }

    public void setComponentClassName(String componentClassName) {
        super.setComponentClassName(componentClassName);
    }

    @Basic
    @Column(name="SUPP_CLASS_NAME", length=4000)
    public String getSupportedClassName() {
        return super.getSupportedClassName();
    }

    public void setSupportedClassName(String supportedClassName) {
        super.setSupportedClassName(supportedClassName);
    }

    @Override
    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    @CollectionTable(name="HIERARCHY_NAMES")
    @Column(name="HIERARCHY_NAME", length=4000)
    @OrderColumn(name="IDX")
    @JoinColumn(name="FK_COMP_ID")
    @BatchFetch(value=BatchFetchType.JOIN)
    public List<String> getHierarchyNames() {
        return super.getHierarchyNames();
    }

    @Transient
    public Profile getProfile() {
        if (super.getProfile() != null && this.m_profilePO != null) {
            return super.getProfile();
        }
        return null;
    }

    @Transient
    public void setProfile(Profile profile) {
        if (profile != null) {
            super.setProfile(profile);
            if (this.m_profilePO == null) {
                this.m_profilePO = PoMaker.createObjectMappingProfile((org.eclipse.jubula.tools.internal.xml.businessmodell.Profile)profile);
            } else {
                this.m_profilePO.useTemplate((org.eclipse.jubula.tools.internal.xml.businessmodell.Profile)profile);
            }
        } else {
            this.m_profilePO = null;
            super.setProfile(null);
        }
    }

    @Override
    public void setHierarchyNames(List<String> hierarchyNames) {
        super.setHierarchyNames(hierarchyNames);
    }

    @Override
    public ICompIdentifierPO makePoClone() {
        CompIdentifierPO clone = new CompIdentifierPO();
        clone.setHierarchyNames(new ArrayList<String>(this.getHierarchyNames()));
        clone.setComponentClassName(this.getComponentClassName());
        if (this.getComponentClassName() != null) {
            clone.setSupportedClassName(this.getComponentClassName());
        }
        if (this.getNeighbours() != null) {
            clone.setNeighbours(new ArrayList<String>(this.getNeighbours()));
        }
        if (this.getParentProjectId() != null) {
            clone.setParentProjectId(this.getParentProjectId());
        }
        if (this.getProfile() != null) {
            clone.setProfile(this.getProfile());
        }
        if (this.getProfilePO() != null) {
            clone.setProfilePO(this.getProfilePO());
        }
        clone.setAlternativeDisplayName(this.getAlternativeDisplayName());
        return clone;
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    @Override
    public void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
    }

    @Basic
    @Column(name="PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Transient
    public String getName() {
        return "";
    }

    @Basic
    @Column(name="ALTERNATIVE_DISPLAY_NAME", length=4000)
    public String getAlternativeDisplayName() {
        return super.getAlternativeDisplayName();
    }

    public void setAlternativeDisplayName(String alternativeDisplayName) {
        super.setAlternativeDisplayName(alternativeDisplayName);
    }

    private void setProfilePO(IObjectMappingProfilePO profile) {
        if (profile != null) {
            super.setProfile((Profile)new org.eclipse.jubula.tools.internal.xml.businessmodell.Profile(profile.getName(), profile.getNameFactor(), profile.getPathFactor(), profile.getContextFactor(), profile.getThreshold()));
        }
        this.m_profilePO = profile;
    }

    @Override
    @OneToOne(targetEntity=ObjectMappingProfilePO.class, optional=true, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="FK_PROFILE", nullable=true)
    public IObjectMappingProfilePO getProfilePO() {
        return this.m_profilePO;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CompIdentifierPO(persistenceObject);
    }

    public CompIdentifierPO(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "hierarchyNames") {
            return this.hierarchyNames;
        }
        if (string == "componentClassName") {
            return this.componentClassName;
        }
        if (string == "supportedClassName") {
            return this.supportedClassName;
        }
        if (string == "neighbours") {
            return this.neighbours;
        }
        if (string == "profilePO") {
            return this.profilePO;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "alternativeDisplayName") {
            return this.alternativeDisplayName;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "hierarchyNames") {
            this.hierarchyNames = (List)object;
            return;
        }
        if (string == "componentClassName") {
            this.componentClassName = (String)object;
            return;
        }
        if (string == "supportedClassName") {
            this.supportedClassName = (String)object;
            return;
        }
        if (string == "neighbours") {
            this.neighbours = (List)object;
            return;
        }
        if (string == "profilePO") {
            this.profilePO = (IObjectMappingProfilePO)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        if (string == "alternativeDisplayName") {
            this.alternativeDisplayName = (String)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

