/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.parser.parameter;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.LinkedList;
import org.eclipse.jubula.client.core.gen.parser.parameter.lexer.LexerException;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.EOF;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.TEndFunctionArgsToken;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.TFunctionToken;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.Token;
import org.eclipse.jubula.client.core.parser.parameter.JubulaParameterLexer;

public class FunctionLocator {
    private String m_functionContents;

    public FunctionLocator(String contents) throws LexerException, IOException {
        JubulaParameterLexer lexer = new JubulaParameterLexer(new PushbackReader(new StringReader(contents)));
        Token token = lexer.next();
        LinkedList<Token> functionTokens = null;
        while (!(token instanceof EOF)) {
            if (token instanceof TFunctionToken) {
                functionTokens = new LinkedList<Token>();
            } else if (token instanceof TEndFunctionArgsToken) {
                functionTokens = null;
            } else if (functionTokens != null) {
                functionTokens.add(token);
            }
            token = lexer.next();
        }
        if (functionTokens != null) {
            StringBuilder functionContentsBuilder = new StringBuilder();
            for (Token tokenInFunction : functionTokens) {
                functionContentsBuilder.append(tokenInFunction.getText());
            }
            this.m_functionContents = functionContentsBuilder.toString();
        }
    }

    public String getCurrentFunction() {
        return this.m_functionContents;
    }
}

