/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the TreeComponentActionHandler component from the concrete toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2020-04-15T07:16:39.234Z")
public class TreeComponentActionHandler extends org.eclipse.jubula.toolkit.base.internal.impl.handler.GraphicsComponentActionHandler implements org.eclipse.jubula.toolkit.concrete.components.handler.TreeComponentActionHandler {
            public TreeComponentActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result collapseNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCollapse")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * 
         */
        public Result collapseNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (indexpath == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCollapseByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result expandNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcExpand")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * 
         */
        public Result expandNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (indexpath == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcExpandByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param extendSelection 
         *        whether to extend the selection or not
         * 
         */
        public Result selectNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton,
            @Nullable BinaryChoice extendSelection
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (mouseButton == null) return null;
            
            if (extendSelection == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelect")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(extendSelection.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param extendSelection 
         *        whether to extend the selection or not
         * 
         */
        public Result selectNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton,
            @Nullable BinaryChoice extendSelection
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (indexpath == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (mouseButton == null) return null;
            
            if (extendSelection == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .addParameter(numberOfClicks)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(extendSelection.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param direction 
         *        the direction to navigate
         * @param numberOfNodes 
         *        the amount of nodes
         * @param numberOfClicks 
         *        the amount of interactions
         * 
         */
        public Result move(
            @Nullable TreeDirection direction,
            @Nullable Integer numberOfNodes,
            @Nullable Integer numberOfClicks
        )  {
            if (direction == null) return null;
            
            if (numberOfNodes == null) return null;
            
            if (numberOfClicks == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcMove")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(direction.rcValue())
                            .addParameter(numberOfNodes)
                            .addParameter(numberOfClicks)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (indexpath == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyPathByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Boolean exists
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (indexpath == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyPathByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkTextOfSelectedNodeS(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkTextOfSelectedNodeS(
            @Nullable String text,
            @Nullable Operator operator
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkTextMousePosition(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyTextAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkTextMousePosition(
            @Nullable String text,
            @Nullable Operator operator
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyTextAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeTextpath 
         *        the tree textpath
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result dragNodeByTextpath(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String treeTextpath,
            @Nullable Operator operator
        )  {
            if (mouseButton == null) return null;
            
            if (modifierKeys == null) return null;
            
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (treeTextpath == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDragByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(treeTextpath)
                            .addParameter(operator.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeTextpath 
         *        the tree textpath
         * @param operator 
         *        the operator used for comparison
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String treeTextpath,
            @Nullable Operator operator,
            @Nullable Integer delayBeforeDropMilliseconds
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (treeTextpath == null) return null;
            
            if (operator == null) return null;
            
            if (delayBeforeDropMilliseconds == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDropByTextPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(treeTextpath)
                            .addParameter(operator.rcValue())
                            .addParameter(delayBeforeDropMilliseconds)
                            .build(), null);
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeIndexpath 
         *        the 1-based tree indexpath
         * 
         */
        public Result dragNodeByIndexpath(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String treeIndexpath
        )  {
            if (mouseButton == null) return null;
            
            if (modifierKeys == null) return null;
            
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (treeIndexpath == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDragByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(treeIndexpath)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeIndexpath 
         *        the 1-based tree indexpath
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String treeIndexpath,
            @Nullable Integer delayBeforeDropMilliseconds
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (treeIndexpath == null) return null;
            
            if (delayBeforeDropMilliseconds == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDropByIndexPath")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(treeIndexpath)
                            .addParameter(delayBeforeDropMilliseconds)
                            .build(), null);
        }
        
        
        
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        )  {
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (operator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckPropertyAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator
        )  {
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckPropertyAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(operator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
} 