/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ViewFactory {
    private static List<IViewPart> views;
    private static SystemTapView newView;

    public static SystemTapView createView(String viewID) {
        Display.getDefault().syncExec(() -> {
            try {
                IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewID);
                if (!(view instanceof SystemTapView)) {
                    return;
                }
                newView = (SystemTapView)view;
                newView.setViewID();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        });
        ViewFactory.addView(newView);
        return newView;
    }

    public static SystemTapView createView(String viewID, String secondaryID) {
        Display.getDefault().syncExec(() -> {
            try {
                IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewID, secondaryID, 2);
                if (!(view instanceof SystemTapView)) {
                    return;
                }
                newView = (SystemTapView)view;
                newView.setViewID();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        });
        ViewFactory.addView(newView);
        return newView;
    }

    public static void addView(SystemTapView view) {
        if (views == null) {
            views = new ArrayList<IViewPart>();
        }
        views.add((IViewPart)view);
    }
}

