/*******************************************************************************
 * Copyright (c) 2015 Tasktop Technologies and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tasktop Technologies - initial API and implementation
 *******************************************************************************/

package org.eclipse.mylyn.internal.gerrit.ui.operations;

import java.util.SortedSet;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

import com.google.common.collect.Sets;

public class BranchProposalProvider implements IContentProposalProvider {

	private final SortedSet<String> proposals;

	public BranchProposalProvider(SortedSet<String> proposals) {
		this.proposals = Sets.newTreeSet(proposals);
	}

	@Override
	public IContentProposal[] getProposals(String contents, int position) {
		Assert.isLegal(contents != null);
		Assert.isLegal(position >= 0);

		SortedSet<BranchContentProposal> branches = Sets.<BranchContentProposal> newTreeSet();
		String searchText = contents.toLowerCase();
		addMatchingProposals(branches, searchText);

		return branches.toArray(new BranchContentProposal[0]);
	}

	private void addMatchingProposals(SortedSet<BranchContentProposal> branches, String searchText) {
		for (String branchProposal : proposals) {
			if (branchProposal.toLowerCase().contains(searchText)) {
				branches.add(new BranchContentProposal(branchProposal));
			}
		}
	}

}
