/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RectangularShadowBorder;
import org.eclipse.papyrus.uml.diagram.sequence.figures.StereotypeInteractionFigure;

public class CombinedFragmentFigure
extends StereotypeInteractionFigure {
    private static final int BRACKET_HEIGHT = 30;
    private WrappingLabel titleLabel;
    private RectangleFigure header;
    private boolean coRegion;

    public WrappingLabel getTitleLabel() {
        return this.titleLabel;
    }

    public IFigure getHeaderContainer() {
        return this.header;
    }

    public void setShadow(boolean shadow) {
        int BORDER_WIDTH = 3;
        if (!shadow) {
            super.setShadow(shadow);
        } else {
            RectangularShadowBorder b = new RectangularShadowBorder(3, this.getForegroundColor()){

                public Insets getInsets(IFigure figure) {
                    return new Insets(1, 1, 1, 1);
                }
            };
            this.setBorder((Border)b);
        }
        Rectangle figureRect = new Rectangle(this.getBounds()).expand(new Insets(0, 0, 3, 3));
        IFigure parent = this.getParent();
        while (parent != null) {
            if (parent.getBounds().contains(figureRect)) {
                parent.revalidate();
                parent.repaint();
                break;
            }
            parent = parent.getParent();
        }
    }

    public void paint(Graphics graphics) {
        if (this.isCoregion()) {
            Rectangle CBbounds = this.getBounds();
            graphics.pushState();
            Rectangle clipRectangle = new Rectangle();
            graphics.getClip(clipRectangle);
            graphics.setClip(clipRectangle.expand(2, 2));
            graphics.setLineWidth(this.getLineWidth());
            graphics.setLineStyle(this.getLineStyle());
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.setBackgroundColor(this.getBackgroundColor());
            PointList list = new PointList();
            Point topLeft = CBbounds.getTopLeft().getCopy().getTranslated(0, 30);
            Point topRight = CBbounds.getTopRight().getCopy().getTranslated(0, 30);
            list.addPoint(topRight);
            list.addPoint(CBbounds.getTopRight().getCopy());
            list.addPoint(CBbounds.getTopLeft().getCopy());
            list.addPoint(topLeft);
            graphics.drawPolyline(list);
            list = new PointList();
            Point bottomLeft = CBbounds.getBottomLeft().getCopy().getTranslated(0, -30);
            Point bottomRight = CBbounds.getBottomRight().getCopy().getTranslated(0, -30);
            list.addPoint(bottomRight);
            list.addPoint(CBbounds.getBottomRight().getCopy());
            list.addPoint(CBbounds.getBottomLeft().getCopy());
            list.addPoint(bottomLeft);
            graphics.drawPolyline(list);
            this.setPreferredSize(new Dimension(40, 100));
            graphics.popState();
        } else {
            super.paint(graphics);
        }
    }

    public boolean isCoregion() {
        return this.coRegion;
    }

    public void setCoregion(boolean coregion) {
        this.coRegion = coregion;
    }
}

