/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.browser;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.AbstractWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.handler.BrowserHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.condition.PageIsLoaded;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.browser.BrowserProgressListener;
import org.eclipse.reddeer.swt.widgets.AbstractControl;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressListener;
import org.hamcrest.Matcher;

public abstract class AbstractBrowser
extends AbstractControl<Browser>
implements org.eclipse.reddeer.swt.api.Browser {
    private static final Logger log = Logger.getLogger(AbstractBrowser.class);
    private BrowserProgressListener browserProgressListener;

    public AbstractBrowser(ReferencedComposite referencedComposite, int index, Matcher<?> ... matchers) {
        super(Browser.class, referencedComposite, index, matchers);
        this.browserProgressListener = new BrowserProgressListener(this);
    }

    public AbstractBrowser(Browser widget) {
        super(widget);
    }

    @Override
    public boolean isPageLoaded() {
        return this.browserProgressListener.isDone();
    }

    @Override
    public void forward() {
        log.info("Browser forward");
        this.setUpProgressListener();
        if (!BrowserHandler.getInstance().forward((Browser)this.getSWTWidget())) {
            throw new SWTLayerException("forward action was not successful");
        }
        new WaitUntil((WaitCondition)new PageIsLoaded(this), TimePeriod.LONG);
        AbstractWait.sleep((TimePeriod)TimePeriod.SHORT);
        this.resetProgressListener();
    }

    @Override
    public void back() {
        log.info("Browser back");
        this.setUpProgressListener();
        if (!BrowserHandler.getInstance().back((Browser)this.getSWTWidget())) {
            throw new SWTLayerException("back action was not successful");
        }
        new WaitUntil((WaitCondition)new PageIsLoaded(this), TimePeriod.LONG);
        AbstractWait.sleep((TimePeriod)TimePeriod.SHORT);
        this.resetProgressListener();
    }

    @Override
    public void setURL(String url) {
        log.info("Set browser URL to '" + url + "'");
        this.setUpProgressListener();
        if (!BrowserHandler.getInstance().setURL((Browser)this.getSWTWidget(), url)) {
            throw new SWTLayerException("setUrl action was not successful");
        }
        new WaitUntil((WaitCondition)new PageIsLoaded(this), TimePeriod.LONG);
        AbstractWait.sleep((TimePeriod)TimePeriod.DEFAULT);
        this.resetProgressListener();
    }

    @Override
    public String getURL() {
        new WaitUntil((WaitCondition)new PageIsLoaded(this));
        return BrowserHandler.getInstance().getURL((Browser)this.getSWTWidget());
    }

    @Override
    public String getText() {
        new WaitUntil((WaitCondition)new PageIsLoaded(this));
        return BrowserHandler.getInstance().getText((Browser)this.getSWTWidget());
    }

    @Override
    public void refresh() {
        log.info("Browser refresh");
        BrowserHandler.getInstance().refresh((Browser)this.getSWTWidget());
    }

    @Override
    public Object evaluate(String script) {
        log.info("Evaluate script: " + script);
        return BrowserHandler.getInstance().evaluate((Browser)this.getSWTWidget(), script);
    }

    @Override
    public boolean execute(String script) {
        log.info("Execute script: " + script);
        return BrowserHandler.getInstance().execute((Browser)this.getSWTWidget(), script);
    }

    private void setUpProgressListener() {
        BrowserHandler.getInstance().addProgressListener((Browser)this.getSWTWidget(), (ProgressListener)this.browserProgressListener);
        this.browserProgressListener.setDone(false);
    }

    private void resetProgressListener() {
        BrowserHandler.getInstance().removeProgressListener((Browser)this.getSWTWidget(), (ProgressListener)this.browserProgressListener);
        this.browserProgressListener.setDone(true);
    }
}

