/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.render;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderedImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusGraphicsSVG;
import org.w3c.dom.Element;

public class SiriusDiagramSVGGenerator
extends DiagramGenerator {
    private RenderedImage renderedImage = null;
    private Element svgRoot = null;
    private Rectangle viewBox = null;
    private IFigure overlayFigure;

    public SiriusDiagramSVGGenerator(DiagramEditPart diagramEditPart) {
        super(diagramEditPart);
        if (diagramEditPart instanceof DDiagramEditPart) {
            this.overlayFigure = ((DDiagramEditPart)diagramEditPart).getOverlayFigure();
        }
    }

    protected Graphics setUpGraphics(int width, int height) {
        this.viewBox = new Rectangle(0, 0, width, height);
        return SiriusGraphicsSVG.getInstance(this.viewBox);
    }

    protected ImageDescriptor getImageDescriptor(Graphics g) {
        try {
            SiriusGraphicsSVG svgG = (SiriusGraphicsSVG)g;
            this.svgRoot = svgG.getRoot();
            ByteArrayOutputStream os = new ByteArrayOutputStream(5000);
            this.stream(os);
            os.close();
            this.setRenderedImage(RenderedImageFactory.getInstance((byte[])os.toByteArray()));
            return RenderedImageDescriptor.createFromRenderedImage((RenderedImage)this.getRenderedImage());
        }
        catch (IOException ex) {
            Log.error((Plugin)DiagramUIRenderPlugin.getInstance(), (int)4, (String)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected void renderToGraphics(Graphics graphics, Point translateOffset, List editparts) {
        super.renderToGraphics(graphics, translateOffset, editparts);
        if (this.overlayFigure != null) {
            this.paintFigure(graphics, this.overlayFigure);
        }
    }

    public void stream(OutputStream outputStream) {
        try {
            this.svgRoot.setAttributeNS(null, "viewBox", String.valueOf(String.valueOf(this.viewBox.x)) + " " + String.valueOf(this.viewBox.y) + " " + String.valueOf(this.viewBox.width) + " " + String.valueOf(this.viewBox.height));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.svgRoot);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            Log.error((Plugin)DiagramUIRenderPlugin.getInstance(), (int)4, (String)ex.getMessage(), (Throwable)ex);
        }
    }

    public Image createAWTImageForParts(List editparts, org.eclipse.swt.graphics.Rectangle sourceRect) {
        this.createSWTImageDescriptorForParts(editparts, sourceRect);
        if (this.getRenderedImage() != null) {
            try {
                BufferedImage bufImg = (BufferedImage)this.getRenderedImage().getAdapter(BufferedImage.class);
                if (bufImg == null) {
                    bufImg = ImageConverter.convert((org.eclipse.swt.graphics.Image)this.getRenderedImage().getSWTImage());
                }
                return bufImg;
            }
            catch (Error e) {
                Trace.catching((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"createAWTImageForParts() failed to generate image", (Throwable)e);
                return ImageConverter.convert((org.eclipse.swt.graphics.Image)SharedImages.get((String)"icons/error.gif"));
            }
            catch (Exception ex) {
                Trace.catching((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"createAWTImageForParts() failed to generate image", (Throwable)ex);
                return ImageConverter.convert((org.eclipse.swt.graphics.Image)SharedImages.get((String)"icons/error.gif"));
            }
        }
        return ImageConverter.convert((org.eclipse.swt.graphics.Image)SharedImages.get((String)"icons/error.gif"));
    }

    public RenderedImage getRenderedImage() {
        return this.renderedImage;
    }

    private void setRenderedImage(RenderedImage renderedImage) {
        this.renderedImage = renderedImage;
    }
}

