/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/language-service/src/symbols", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /**
     * An enumeration of basic types.
     *
     * @publicApi
     */
    var BuiltinType;
    (function (BuiltinType) {
        /**
         * The type is a type that can hold any other type.
         */
        BuiltinType[BuiltinType["Any"] = 0] = "Any";
        /**
         * The type of a string literal.
         */
        BuiltinType[BuiltinType["String"] = 1] = "String";
        /**
         * The type of a numeric literal.
         */
        BuiltinType[BuiltinType["Number"] = 2] = "Number";
        /**
         * The type of the `true` and `false` literals.
         */
        BuiltinType[BuiltinType["Boolean"] = 3] = "Boolean";
        /**
         * The type of the `undefined` literal.
         */
        BuiltinType[BuiltinType["Undefined"] = 4] = "Undefined";
        /**
         * the type of the `null` literal.
         */
        BuiltinType[BuiltinType["Null"] = 5] = "Null";
        /**
         * the type is an unbound type parameter.
         */
        BuiltinType[BuiltinType["Unbound"] = 6] = "Unbound";
        /**
         * Not a built-in type.
         */
        BuiltinType[BuiltinType["Other"] = 7] = "Other";
    })(BuiltinType = exports.BuiltinType || (exports.BuiltinType = {}));
});
//# sourceMappingURL=data:application/json;base64,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