import { DebugProtocol } from 'vscode-debugprotocol';
import { IStackTraceResponseBody } from '../debugAdapterInterfaces';
import { Protocol as Crdp } from 'devtools-protocol';
import { Transformers } from './chromeDebugAdapter';
import { ScriptContainer } from './scripts';
import { SmartStepper } from './smartStep';
import { ScriptSkipper } from './scriptSkipping';
import { VariablesManager } from './variablesManager';
export declare class StackFrames {
    private _frameHandles;
    constructor();
    /**
     * Clear the currently stored stack frames
     */
    reset(): void;
    /**
     * Get a stack frame by its id
     */
    getFrame(frameId: number): Crdp.Debugger.CallFrame;
    getStackTrace({args, scripts, originProvider, scriptSkipper, smartStepper, transformers, pauseEvent}: {
        args: DebugProtocol.StackTraceArguments;
        scripts: ScriptContainer;
        originProvider: (url: string) => string;
        scriptSkipper: ScriptSkipper;
        smartStepper: SmartStepper;
        transformers: Transformers;
        pauseEvent: Crdp.Debugger.PausedEvent;
    }): Promise<IStackTraceResponseBody>;
    getScopes({args, scripts, transformers, variables, pauseEvent, currentException}: {
        args: DebugProtocol.ScopesArguments;
        scripts: ScriptContainer;
        transformers: Transformers;
        variables: VariablesManager;
        pauseEvent: Crdp.Debugger.PausedEvent;
        currentException: any;
    }): {
        scopes: DebugProtocol.Scope[];
    };
    mapCallFrame(frame: Crdp.Runtime.CallFrame, transformers: Transformers, scripts: ScriptContainer, originProvider: (url: string) => string): Promise<DebugProtocol.StackFrame>;
    mapFormattedException(formattedException: string, transformers: Transformers): Promise<string>;
    private asyncFrames(stackTrace, scripts, originProvider);
    private runtimeCFToDebuggerCF(frame);
    private formatStackFrameName(frame, formatArgs?);
    callFrameToStackFrame(frame: Crdp.Debugger.CallFrame, scripts: ScriptContainer, originProvider: (url: string) => string): DebugProtocol.StackFrame;
    /**
     * Try to lookup the index of the frame with given ID. Returns -1 for async frames and unknown frames.
     */
    lookupFrameIndex(frameId: number, pauseEvent: Crdp.Debugger.PausedEvent): number;
}
