/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionPassException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BP4101
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP4101(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document doc = entryContext.getMessageEntryDocument();
            if (doc == null) {
                throw new AssertionNotApplicableException();
            }
            Element root = doc.getDocumentElement();
            NodeList headerList = root.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (headerList == null || headerList.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            Node header = headerList.item(0);
            NodeList elems = header.getChildNodes();
            if (elems == null || elems.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            int i = 0;
            while (i < elems.getLength()) {
                Node actor;
                NamedNodeMap attrs = elems.item(i).getAttributes();
                if (attrs != null && (actor = attrs.getNamedItem(String.valueOf(root.getPrefix()) + ":" + "actor")) != null && !actor.getNodeValue().equals("http://schemas.xmlsoap.org/soap/actor/next")) {
                    throw new AssertionPassException();
                }
                ++i;
            }
            this.result = "notApplicable";
        }
        catch (AssertionPassException assertionPassException) {
            this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription(), entryContext);
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

